/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.PredictionProviderFactory;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.api.ModelIdentifier;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandlerRegistry;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LocalExplainerServiceHandlerRegistryTest {
    private static final String EXECUTION_ID = "executionId";
    private static final String SERVICE_URL = "serviceURL";
    private static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("resourceType", "resourceId");
    private static final String COUNTERFACTUAL_ID = "counterfactualId";
    private static final Long MAX_RUNNING_TIME_SECONDS = 60L;
    private LimeExplainerServiceHandler limeExplainerServiceHandler;
    private CounterfactualExplainerServiceHandler counterfactualExplainerServiceHandler;
    private PredictionProvider predictionProvider;
    private Consumer<BaseExplainabilityResult> callback;
    private LocalExplainerServiceHandlerRegistry registry;

    @BeforeEach
    public void setup() {
        LimeExplainer limeExplainer = (LimeExplainer)Mockito.mock(LimeExplainer.class);
        CounterfactualExplainer counterfactualExplainer = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        PredictionProviderFactory predictionProviderFactory = (PredictionProviderFactory)Mockito.mock(PredictionProviderFactory.class);
        this.limeExplainerServiceHandler = (LimeExplainerServiceHandler)Mockito.spy((Object)new LimeExplainerServiceHandler(limeExplainer, predictionProviderFactory));
        this.counterfactualExplainerServiceHandler = (CounterfactualExplainerServiceHandler)Mockito.spy((Object)new CounterfactualExplainerServiceHandler(counterfactualExplainer, predictionProviderFactory, MAX_RUNNING_TIME_SECONDS));
        this.predictionProvider = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.callback = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)predictionProviderFactory.createPredictionProvider((String)ArgumentMatchers.any(), (ModelIdentifier)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any())).thenReturn((Object)this.predictionProvider);
        Instance explanationHandlers = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)explanationHandlers.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandler, this.counterfactualExplainerServiceHandler));
        this.registry = new LocalExplainerServiceHandlerRegistry(explanationHandlers);
    }

    @Test
    public void testLIME_explainAsyncWithResults() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyList(), Collections.emptyList());
        this.registry.explainAsyncWithResults((BaseExplainabilityRequest)request, this.callback);
        ((LimeExplainerServiceHandler)Mockito.verify((Object)this.limeExplainerServiceHandler)).explainAsyncWithResults((BaseExplainabilityRequest)((LIMEExplainabilityRequest)ArgumentMatchers.eq((Object)request)), (Consumer)ArgumentMatchers.eq(this.callback));
    }

    @Test
    public void testCounterfactual_explainAsyncWithResults() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, COUNTERFACTUAL_ID, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), MAX_RUNNING_TIME_SECONDS);
        this.registry.explainAsyncWithResults((BaseExplainabilityRequest)request, this.callback);
        ((CounterfactualExplainerServiceHandler)Mockito.verify((Object)this.counterfactualExplainerServiceHandler)).explainAsyncWithResults((BaseExplainabilityRequest)((CounterfactualExplainabilityRequest)ArgumentMatchers.eq((Object)request)), (Consumer)ArgumentMatchers.eq(this.callback));
    }
}

