/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.ExplanationServiceImpl;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ExplanationServiceImplTest {
    ExplanationServiceImpl explanationService;
    LocalExplainer<Map<String, Saliency>> localExplainerMock;
    PredictionProvider predictionProviderMock;

    ExplanationServiceImplTest() {
    }

    @BeforeEach
    void init() {
        this.localExplainerMock = (LocalExplainer)Mockito.mock(LocalExplainer.class);
        this.predictionProviderMock = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.explanationService = new ExplanationServiceImpl(this.localExplainerMock);
    }

    @Test
    void testExplainAsyncSucceeded() {
        Mockito.when((Object)this.localExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock))).thenReturn(CompletableFuture.completedFuture(TestUtils.SALIENCY_MAP));
        LIMEExplainabilityResultDto resultDto = (LIMEExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync(TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertEquals((Object)"executionId", (Object)resultDto.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.SUCCEEDED, (Object)resultDto.getStatus());
        Assertions.assertNull((Object)resultDto.getStatusDetails());
        Assertions.assertEquals((int)TestUtils.SALIENCY_MAP.size(), (int)resultDto.getSaliencies().size());
        Assertions.assertTrue((boolean)resultDto.getSaliencies().containsKey("key"));
        SaliencyDto saliencyDto = (SaliencyDto)resultDto.getSaliencies().get("key");
        Assertions.assertEquals((int)TestUtils.SALIENCY.getPerFeatureImportance().size(), (int)saliencyDto.getFeatureImportance().size());
        FeatureImportanceDto featureImportanceDto1 = (FeatureImportanceDto)saliencyDto.getFeatureImportance().get(0);
        Assertions.assertEquals((Object)TestUtils.FEATURE_IMPORTANCE_1.getFeature().getName(), (Object)featureImportanceDto1.getFeatureName());
        Assertions.assertEquals((double)TestUtils.FEATURE_IMPORTANCE_1.getScore(), (double)featureImportanceDto1.getScore(), (double)0.01);
    }

    @Test
    void testExplainAsyncFailed() {
        Mockito.when((Object)this.localExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock))).thenThrow(RuntimeException.class);
        LIMEExplainabilityResultDto resultDto = (LIMEExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync(TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertEquals((Object)"executionId", (Object)resultDto.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.FAILED, (Object)resultDto.getStatus());
        Assertions.assertEquals((Object)"Failed to calculate values", (Object)resultDto.getStatusDetails());
        Assertions.assertNull((Object)resultDto.getSaliencies());
    }
}

