/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;

public class ConversionUtils {
    private ConversionUtils() {
    }

    protected static Feature toFeature(String name, Object value) {
        if (value instanceof JsonObject) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList((JsonObject)value));
        }
        return ConversionUtils.toTypeValuePair(value).map(p -> new Feature(name, (Type)p.getLeft(), (Value)p.getRight())).orElse(null);
    }

    public static Feature toFeature(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(value.toUnit().getValue()).map(p -> new Feature(name, (Type)p.getLeft(), (Value)p.getRight())).orElse(null);
        }
        if (value.isStructure()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(value.toStructure().getValue()));
        }
        if (value.isCollection()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(name, value.toCollection()));
        }
        throw new IllegalArgumentException(String.format("unexpected value kind %s", value.getKind()));
    }

    protected static List<Feature> toFeatureList(String name, CollectionValue collectionValue) {
        Collection values = collectionValue.getValue();
        ArrayList<Feature> list = new ArrayList<Feature>(values.size());
        int index = 0;
        for (TypedValue typedValue : values) {
            list.add(ConversionUtils.toFeature(name + "_" + index, typedValue));
            ++index;
        }
        return list;
    }

    public static List<Feature> toFeatureList(JsonObject mainObj) {
        return ConversionUtils.toList(mainObj, ConversionUtils::toFeature);
    }

    public static List<Feature> toFeatureList(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toFeature);
    }

    public static <T> List<T> toList(JsonObject mainObj, BiFunction<String, Object, T> unitConverter) {
        if (mainObj == null) {
            return Collections.emptyList();
        }
        return mainObj.stream().map(entry -> unitConverter.apply((String)entry.getKey(), entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T> List<T> toList(Map<String, TypedValue> values, BiFunction<String, TypedValue, T> unitConverter) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.entrySet().stream().map(entry -> unitConverter.apply((String)entry.getKey(), (TypedValue)entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static Output toOutput(String name, Object value) {
        if (value instanceof JsonObject) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toFeatureList((JsonObject)value)), 1.0);
        }
        return ConversionUtils.toTypeValuePair(value).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
    }

    public static Output toOutput(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(value.toUnit().getValue()).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
        }
        if (value.isStructure()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toFeatureList(value.toStructure().getValue())), 1.0);
        }
        if (value.isCollection()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toFeatureList(name, value.toCollection())), 1.0);
        }
        return null;
    }

    public static List<Output> toOutputList(JsonObject mainObj) {
        return ConversionUtils.toList(mainObj, ConversionUtils::toOutput);
    }

    public static List<Output> toOutputList(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toOutput);
    }

    protected static Optional<Pair<Type, Value>> toTypeValuePair(Object value) {
        if (value instanceof Boolean) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value(value)));
        }
        if (value instanceof Number) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)((Number)value).doubleValue())));
        }
        if (value instanceof String) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value(value)));
        }
        return Optional.empty();
    }

    public static Optional<Pair<Type, Value>> toTypeValuePair(JsonNode jsonValue) {
        if (jsonValue.isBoolean()) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value((Object)jsonValue.asBoolean())));
        }
        if (jsonValue.isNumber()) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)jsonValue.asDouble())));
        }
        if (jsonValue.isTextual()) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value((Object)jsonValue.asText())));
        }
        return Optional.empty();
    }
}

