/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.local.LocalExplainer;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.kie.kogito.explainability.model.Saliency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LimeExplainerProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LimeExplainerProducer.class);
    private final Integer numberOfSamples;
    private final Integer numberOfPerturbations;

    @Inject
    public LimeExplainerProducer(@ConfigProperty(name="trusty.explainability.numberOfSamples", defaultValue="100") Integer numberOfSamples, @ConfigProperty(name="trusty.explainability.numberOfPerturbations", defaultValue="1") Integer numberOfPerturbations) {
        this.numberOfSamples = numberOfSamples;
        this.numberOfPerturbations = numberOfPerturbations;
    }

    @Produces
    public LocalExplainer<Map<String, Saliency>> produce() {
        LOG.debug("LimeExplainer created (numberOfSamples={}, numberOfPerturbations={})", (Object)this.numberOfSamples, (Object)this.numberOfPerturbations);
        LimeConfig limeConfig = new LimeConfig().withSamples(this.numberOfSamples.intValue()).withPerturbationContext(new PerturbationContext((Random)new SecureRandom(), this.numberOfPerturbations.intValue()));
        return new LimeExplainer(limeConfig);
    }
}

