/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.Config;
import org.kie.kogito.explainability.ExplanationServiceImpl;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandlerRegistry;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class ExplanationServiceImplTest {
    Instance instance;
    ExplanationServiceImpl explanationService;
    LimeExplainer limeExplainerMock;
    LimeExplainerServiceHandler limeExplainerServiceHandlerMock;
    CounterfactualExplainer cfExplainerMock;
    CounterfactualExplainerServiceHandler cfExplainerServiceHandlerMock;
    LocalExplainerServiceHandlerRegistry explainerServiceHandlerRegistry;
    PredictionProvider predictionProviderMock;

    ExplanationServiceImplTest() {
    }

    @BeforeEach
    void init() {
        this.instance = (Instance)Mockito.mock(Instance.class);
        this.limeExplainerMock = (LimeExplainer)Mockito.mock(LimeExplainer.class);
        this.cfExplainerMock = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        this.limeExplainerServiceHandlerMock = (LimeExplainerServiceHandler)Mockito.spy((Object)new LimeExplainerServiceHandler(this.limeExplainerMock));
        this.cfExplainerServiceHandlerMock = (CounterfactualExplainerServiceHandler)Mockito.spy((Object)new CounterfactualExplainerServiceHandler(this.cfExplainerMock));
        this.explainerServiceHandlerRegistry = new LocalExplainerServiceHandlerRegistry(this.instance);
        this.predictionProviderMock = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.explanationService = new ExplanationServiceImpl(this.explainerServiceHandlerRegistry);
    }

    @Test
    void testLIMEExplainAsyncSucceeded() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        Mockito.when((Object)this.limeExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock))).thenReturn(CompletableFuture.completedFuture(TestUtils.SALIENCY_MAP));
        BaseExplainabilityResultDto resultDto = (BaseExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertTrue((boolean)(resultDto instanceof LIMEExplainabilityResultDto));
        LIMEExplainabilityResultDto limeResultDto = (LIMEExplainabilityResultDto)resultDto;
        Assertions.assertEquals((Object)"executionId", (Object)limeResultDto.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.SUCCEEDED, (Object)limeResultDto.getStatus());
        Assertions.assertNull((Object)limeResultDto.getStatusDetails());
        Assertions.assertEquals((int)TestUtils.SALIENCY_MAP.size(), (int)limeResultDto.getSaliencies().size());
        Assertions.assertTrue((boolean)limeResultDto.getSaliencies().containsKey("key"));
        SaliencyDto saliencyDto = (SaliencyDto)limeResultDto.getSaliencies().get("key");
        Assertions.assertEquals((int)TestUtils.SALIENCY.getPerFeatureImportance().size(), (int)saliencyDto.getFeatureImportance().size());
        FeatureImportanceDto featureImportanceDto1 = (FeatureImportanceDto)saliencyDto.getFeatureImportance().get(0);
        Assertions.assertEquals((Object)TestUtils.FEATURE_IMPORTANCE_1.getFeature().getName(), (Object)featureImportanceDto1.getFeatureName());
        Assertions.assertEquals((double)TestUtils.FEATURE_IMPORTANCE_1.getScore(), (double)featureImportanceDto1.getScore(), (double)0.01);
    }

    @Test
    void testServiceCallFailed() {
        String errorMessage = "Something bad happened";
        RuntimeException exception = new RuntimeException(errorMessage);
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        ((LimeExplainerServiceHandler)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.limeExplainerServiceHandlerMock)).supports((Class)ArgumentMatchers.any());
        Assertions.assertThrows(RuntimeException.class, () -> this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
    }

    @Test
    void testServiceCallFailedNoMatchingServiceHandlers() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
    }

    @Test
    void testLIMEExplainAsyncFailed() {
        String errorMessage = "Something bad happened";
        RuntimeException exception = new RuntimeException(errorMessage);
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock));
        Mockito.when((Object)this.limeExplainerMock.explainAsync((Prediction)ArgumentMatchers.any(Prediction.class), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProviderMock))).thenThrow(new Throwable[]{exception});
        BaseExplainabilityResultDto resultDto = (BaseExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertTrue((boolean)(resultDto instanceof LIMEExplainabilityResultDto));
        LIMEExplainabilityResultDto exceptionResultDto = (LIMEExplainabilityResultDto)resultDto;
        Assertions.assertEquals((Object)"executionId", (Object)exceptionResultDto.getExecutionId());
        Assertions.assertSame((Object)ExplainabilityStatus.FAILED, (Object)exceptionResultDto.getStatus());
        Assertions.assertEquals((Object)errorMessage, (Object)exceptionResultDto.getStatusDetails());
    }

    @Test
    void testServiceHandlerLookupLIME() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock, this.cfExplainerServiceHandlerMock));
        BaseExplainabilityResultDto resultDto = (BaseExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertTrue((boolean)(resultDto instanceof LIMEExplainabilityResultDto));
    }

    @Test
    void testServiceHandlerLookupCounterfactuals() {
        Mockito.when((Object)this.instance.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandlerMock, this.cfExplainerServiceHandlerMock));
        BaseExplainabilityResultDto resultDto = (BaseExplainabilityResultDto)Assertions.assertDoesNotThrow(() -> (BaseExplainabilityResultDto)this.explanationService.explainAsync((BaseExplainabilityRequest)TestUtils.COUNTERFACTUAL_REQUEST, this.predictionProviderMock).toCompletableFuture().get(Config.INSTANCE.getAsyncTimeout(), Config.INSTANCE.getAsyncTimeUnit()));
        Assertions.assertNotNull((Object)resultDto);
        Assertions.assertTrue((boolean)(resultDto instanceof CounterfactualExplainabilityResultDto));
    }
}

