/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.RemotePredictionProvider;
import org.kie.kogito.explainability.TestUtils;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.PredictionOutput;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;

class RemotePredictionProviderTest {
    RemotePredictionProvider predictionProvider = new RemotePredictionProvider((BaseExplainabilityRequest)TestUtils.LIME_REQUEST, null, null, null){

        protected WebClient getClient(Vertx vertx, URI uri) {
            return null;
        }
    };

    RemotePredictionProviderTest() {
    }

    @Test
    void toPredictionOutput() {
        Assertions.assertNull((Object)this.predictionProvider.toPredictionOutput(null));
        Assertions.assertNull((Object)this.predictionProvider.toPredictionOutput(new JsonObject(Collections.emptyMap())));
        Map predictionMap = Collections.singletonMap("result", Collections.emptyMap());
        PredictionOutput predictionOutput = this.predictionProvider.toPredictionOutput(new JsonObject(predictionMap));
        Assertions.assertNotNull((Object)predictionOutput);
        Assertions.assertEquals((int)TestUtils.LIME_REQUEST.getOutputs().size(), (int)predictionOutput.getOutputs().size());
        Assertions.assertEquals((Object)Type.UNDEFINED, (Object)((Output)predictionOutput.getOutputs().get(0)).getType());
    }

    @Test
    void toMap() {
        Feature simple = new Feature("simple", Type.NUMBER, new Value((Object)10));
        Feature undefined = new Feature("undefined", Type.UNDEFINED, new Value((Object)simple));
        Feature composite = new Feature("composite", Type.COMPOSITE, new Value(Arrays.asList(simple, undefined)));
        List<Feature> features1 = Arrays.asList(simple, undefined, composite);
        Map result1 = this.predictionProvider.toMap(features1);
        Assertions.assertNotNull((Object)result1);
        Assertions.assertEquals((int)features1.size(), (int)result1.size());
        Assertions.assertTrue((boolean)result1.containsKey("simple"));
        Assertions.assertEquals((Object)10, result1.get("simple"));
        Assertions.assertTrue((boolean)result1.containsKey("undefined"));
        Assertions.assertTrue((boolean)result1.containsKey("composite"));
        Assertions.assertTrue((boolean)(result1.get("composite") instanceof Map));
        Feature context = new Feature("context", Type.COMPOSITE, new Value(Collections.singletonList(simple)));
        Feature simple2 = new Feature("simple2", Type.BOOLEAN, new Value((Object)true));
        List<Feature> features2 = Arrays.asList(simple2, context);
        Map result2 = this.predictionProvider.toMap(features2);
        Assertions.assertNotNull((Object)result2);
        Assertions.assertEquals((int)1, (int)result2.size());
        Assertions.assertTrue((boolean)result2.containsKey("simple"));
        Assertions.assertFalse((boolean)result2.containsKey("simple2"));
        Feature nestedComposite = new Feature("nestedComposite", Type.COMPOSITE, new Value(Arrays.asList(simple, composite)));
        List<Feature> features3 = Arrays.asList(simple, nestedComposite);
        Map result3 = this.predictionProvider.toMap(features3);
        Assertions.assertNotNull((Object)result3);
        Assertions.assertEquals((int)features3.size(), (int)result3.size());
        Assertions.assertTrue((boolean)result3.containsKey("simple"));
        Assertions.assertEquals((Object)10, result3.get("simple"));
        Assertions.assertTrue((boolean)result3.containsKey("nestedComposite"));
        Assertions.assertTrue((boolean)(result3.get("nestedComposite") instanceof Map));
        Map nestedCompositeMap = (Map)result3.get("nestedComposite");
        Assertions.assertEquals((int)2, (int)nestedCompositeMap.size());
        Assertions.assertTrue((boolean)nestedCompositeMap.containsKey("simple"));
        Assertions.assertEquals((Object)10, nestedCompositeMap.get("simple"));
        Assertions.assertTrue((boolean)nestedCompositeMap.containsKey("composite"));
        Assertions.assertTrue((boolean)(nestedCompositeMap.get("composite") instanceof Map));
    }
}

