/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequestDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.models.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.models.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;

public class TestUtils {
    public static final String EXECUTION_ID = "executionId";
    public static final String COUNTERFACTUAL_ID = "counterfactualId";
    public static final String SERVICE_URL = "localhost:8080";
    public static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("dmn", "name:namespace");
    public static final Value VALUE = new Value((Object)true);
    public static final FeatureImportance FEATURE_IMPORTANCE_1 = new FeatureImportance(new Feature("input1", Type.NUMBER, new Value((Object)1)), 0.6);
    public static final FeatureImportance FEATURE_IMPORTANCE_2 = new FeatureImportance(new Feature("input2", Type.NUMBER, new Value((Object)2)), 0.5);
    public static final List<FeatureImportance> FEATURE_IMPORTANCES = Arrays.asList(FEATURE_IMPORTANCE_1, FEATURE_IMPORTANCE_2);
    public static final Output OUTPUT = new Output("key", Type.BOOLEAN, VALUE, 1.0);
    public static final Saliency SALIENCY = new Saliency(OUTPUT, FEATURE_IMPORTANCES);
    public static final Map<String, Saliency> SALIENCY_MAP = Collections.singletonMap("key", SALIENCY);
    public static final Map<String, TypedValue> INPUTS = new HashMap<String, TypedValue>();
    public static final Map<String, CounterfactualSearchDomainDto> SEARCH_DOMAINS;
    public static final Map<String, TypedValue> OUTPUTS;
    public static final CounterfactualExplainabilityRequestDto COUNTERFACTUAL_REQUEST_DTO;
    public static final LIMEExplainabilityRequestDto LIME_REQUEST_DTO;
    public static final LIMEExplainabilityRequest LIME_REQUEST;
    public static final CounterfactualExplainabilityRequest COUNTERFACTUAL_REQUEST;

    private TestUtils() {
    }

    static {
        INPUTS.put("input1", (TypedValue)new UnitValue("string", (JsonNode)new TextNode("value")));
        INPUTS.put("input2", (TypedValue)new UnitValue("number", (JsonNode)new DoubleNode(10.0)));
        SEARCH_DOMAINS = new HashMap<String, CounterfactualSearchDomainDto>();
        OUTPUTS = Collections.singletonMap("output1", new UnitValue("string", (JsonNode)new TextNode("output")));
        COUNTERFACTUAL_REQUEST_DTO = new CounterfactualExplainabilityRequestDto(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, (ModelIdentifierDto)MODEL_IDENTIFIER, INPUTS, OUTPUTS, SEARCH_DOMAINS);
        LIME_REQUEST_DTO = new LIMEExplainabilityRequestDto(EXECUTION_ID, SERVICE_URL, (ModelIdentifierDto)MODEL_IDENTIFIER, INPUTS, OUTPUTS);
        LIME_REQUEST = new LimeExplainerServiceHandler(null).explainabilityRequestFrom(LIME_REQUEST_DTO);
        COUNTERFACTUAL_REQUEST = new CounterfactualExplainerServiceHandler(null).explainabilityRequestFrom(COUNTERFACTUAL_REQUEST_DTO);
    }
}

