/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.CounterfactualDomainDto;
import org.kie.kogito.explainability.api.CounterfactualDomainRangeDto;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequestDto;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityResultDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainCollectionDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainStructureDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainUnitDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualResult;
import org.kie.kogito.explainability.model.CounterfactualPrediction;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;
import org.kie.kogito.explainability.models.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CounterfactualExplainerServiceHandlerTest {
    private static final String EXECUTION_ID = UUID.randomUUID().toString();
    private static final String COUNTERFACTUAL_ID = UUID.randomUUID().toString();
    private static final String SOLUTION_ID = UUID.randomUUID().toString();
    private static final String SERVICE_URL = "serviceURL";
    private static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("resourceType", "resourceId");
    private static final ModelIdentifierDto MODEL_IDENTIFIER_DTO = new ModelIdentifierDto("resourceType", "resourceId");
    private CounterfactualExplainer explainer;
    private CounterfactualExplainerServiceHandler handler;

    @BeforeEach
    public void setup() {
        this.explainer = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        this.handler = new CounterfactualExplainerServiceHandler(this.explainer);
    }

    @Test
    public void testSupports() {
        Assertions.assertTrue((boolean)this.handler.supports(CounterfactualExplainabilityRequest.class));
        Assertions.assertFalse((boolean)this.handler.supports(BaseExplainabilityRequest.class));
    }

    @Test
    public void testSupportsDo() {
        Assertions.assertTrue((boolean)this.handler.supportsDto(CounterfactualExplainabilityRequestDto.class));
        Assertions.assertFalse((boolean)this.handler.supportsDto(BaseExplainabilityRequestDto.class));
    }

    @Test
    public void testExplainabilityRequestFrom() {
        CounterfactualExplainabilityRequestDto requestDto = new CounterfactualExplainabilityRequestDto(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER_DTO, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        CounterfactualExplainabilityRequest request = this.handler.explainabilityRequestFrom(requestDto);
        Assertions.assertEquals((Object)requestDto.getExecutionId(), (Object)request.getExecutionId());
        Assertions.assertEquals((Object)requestDto.getCounterfactualId(), (Object)request.getCounterfactualId());
        Assertions.assertEquals((Object)requestDto.getServiceUrl(), (Object)request.getServiceUrl());
        Assertions.assertEquals((Object)requestDto.getModelIdentifier().getResourceId(), (Object)request.getModelIdentifier().getResourceId());
        Assertions.assertEquals((Object)requestDto.getModelIdentifier().getResourceType(), (Object)request.getModelIdentifier().getResourceType());
        Assertions.assertEquals((Object)requestDto.getInputs(), (Object)request.getInputs());
        Assertions.assertEquals((Object)requestDto.getOutputs(), (Object)request.getOutputs());
        Assertions.assertEquals((Object)requestDto.getSearchDomains(), (Object)request.getSearchDomains());
    }

    @Test
    public void testGetPredictionWithEmptyDefinition() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        CounterfactualPrediction prediction = (CounterfactualPrediction)this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)prediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)prediction.getOutput().getOutputs().isEmpty());
        Assertions.assertTrue((boolean)prediction.getDomain().getFeatureDomains().isEmpty());
    }

    @Test
    public void testGetPredictionWithFlatInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Map.of("input1", new UnitValue("number", (JsonNode)new IntNode(20))), Collections.emptyMap(), Collections.emptyMap());
        CounterfactualPrediction prediction = (CounterfactualPrediction)this.handler.getPrediction(request);
        Assertions.assertEquals((int)1, (int)prediction.getInput().getFeatures().size());
        Optional<Feature> oInput1 = prediction.getInput().getFeatures().stream().filter(f -> f.getName().equals("input1")).findFirst();
        Assertions.assertTrue((boolean)oInput1.isPresent());
        Feature input1 = oInput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)input1.getType());
        Assertions.assertEquals((double)20.0, (double)input1.getValue().asNumber());
        Assertions.assertTrue((boolean)prediction.getOutput().getOutputs().isEmpty());
        Assertions.assertTrue((boolean)prediction.getDomain().getFeatureDomains().isEmpty());
    }

    @Test
    public void testGetPredictionWithStructuredInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Map.of("input1", new StructureValue("number", Map.of("input2b", new UnitValue("number", (JsonNode)new IntNode(55))))), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionInputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Map.of("input1", new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100))))), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithFlatOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Map.of("output1", new UnitValue("number", (JsonNode)new IntNode(20))), Collections.emptyMap());
        CounterfactualPrediction prediction = (CounterfactualPrediction)this.handler.getPrediction(request);
        Assertions.assertEquals((int)1, (int)prediction.getOutput().getOutputs().size());
        Optional<Output> oOutput1 = prediction.getOutput().getOutputs().stream().filter(f -> f.getName().equals("output1")).findFirst();
        Assertions.assertTrue((boolean)oOutput1.isPresent());
        Output output1 = oOutput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output1.getType());
        Assertions.assertEquals((double)20.0, (double)output1.getValue().asNumber());
        Assertions.assertTrue((boolean)prediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)prediction.getDomain().getFeatureDomains().isEmpty());
        Assertions.assertTrue((boolean)prediction.getConstraints().isEmpty());
    }

    @Test
    public void testGetPredictionWithStructuredOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Map.of("input1", new StructureValue("number", Map.of("input2b", new UnitValue("number", (JsonNode)new IntNode(55))))), Collections.emptyMap());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionOutputModel() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Map.of("input1", new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100))))), Collections.emptyMap());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithFlatSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Map.of("output1", new CounterfactualSearchDomainUnitDto("number", Boolean.valueOf(true), (CounterfactualDomainDto)new CounterfactualDomainRangeDto((JsonNode)new IntNode(10), (JsonNode)new IntNode(20)))));
        CounterfactualPrediction prediction = (CounterfactualPrediction)this.handler.getPrediction(request);
        Assertions.assertEquals((int)1, (int)prediction.getDomain().getFeatureDomains().size());
        FeatureDomain featureDomain1 = (FeatureDomain)prediction.getDomain().getFeatureDomains().get(0);
        Assertions.assertEquals((double)10.0, (Double)featureDomain1.getLowerBound());
        Assertions.assertEquals((double)20.0, (Double)featureDomain1.getUpperBound());
        Assertions.assertTrue((boolean)prediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)prediction.getOutput().getOutputs().isEmpty());
        Assertions.assertEquals((int)1, (int)prediction.getConstraints().size());
        Assertions.assertTrue((boolean)((Boolean)prediction.getConstraints().get(0)));
    }

    @Test
    public void testGetPredictionWithStructuredSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Map.of("input1", new CounterfactualSearchDomainStructureDto("number", Map.of("input2b", new CounterfactualSearchDomainUnitDto("number", Boolean.valueOf(true), (CounterfactualDomainDto)new CounterfactualDomainRangeDto((JsonNode)new IntNode(10), (JsonNode)new IntNode(20)))))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    public void testGetPredictionWithCollectionSearchDomains() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Map.of("input1", new CounterfactualSearchDomainCollectionDto("number", List.of(new CounterfactualSearchDomainUnitDto("number", Boolean.valueOf(true), (CounterfactualDomainDto)new CounterfactualDomainRangeDto((JsonNode)new IntNode(10), (JsonNode)new IntNode(20)))))));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.handler.getPrediction(request));
    }

    @Test
    @Disabled(value="See https://issues.redhat.com/browse/FAI-439")
    public void testCreateSucceededResultDto() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        CounterfactualResult counterfactuals = new CounterfactualResult(Collections.emptyList(), Collections.emptyList(), true, UUID.fromString(SOLUTION_ID), UUID.fromString(EXECUTION_ID));
        BaseExplainabilityResultDto base = this.handler.createSucceededResultDto(request, counterfactuals);
        Assertions.assertTrue((boolean)(base instanceof CounterfactualExplainabilityResultDto));
        CounterfactualExplainabilityResultDto result = (CounterfactualExplainabilityResultDto)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.SUCCEEDED, (Object)result.getStatus());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((Object)COUNTERFACTUAL_ID, (Object)result.getCounterfactualId());
        Assertions.assertTrue((boolean)result.getInputs().isEmpty());
        Assertions.assertTrue((boolean)result.getOutputs().isEmpty());
    }

    @Test
    public void testCreateFailedResultDto() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        BaseExplainabilityResultDto base = this.handler.createFailedResultDto(request, (Throwable)new NullPointerException("Something went wrong"));
        Assertions.assertTrue((boolean)(base instanceof CounterfactualExplainabilityResultDto));
        CounterfactualExplainabilityResultDto result = (CounterfactualExplainabilityResultDto)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.FAILED, (Object)result.getStatus());
        Assertions.assertEquals((Object)"Something went wrong", (Object)result.getStatusDetails());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((Object)COUNTERFACTUAL_ID, (Object)result.getCounterfactualId());
    }

    @Test
    public void testExplainAsyncDelegation() {
        Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
        PredictionProvider model = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.handler.explainAsync(prediction, model);
        ((CounterfactualExplainer)Mockito.verify((Object)this.explainer)).explainAsync((Prediction)ArgumentMatchers.eq((Object)prediction), (PredictionProvider)ArgumentMatchers.eq((Object)model));
    }
}

