/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.BaseExplainabilityResultDto;
import org.kie.kogito.explainability.api.ExplainabilityStatus;
import org.kie.kogito.explainability.api.FeatureImportanceDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityResultDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.explainability.api.SaliencyDto;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureImportance;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Prediction;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.model.Saliency;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;
import org.kie.kogito.explainability.models.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.StructureValue;
import org.kie.kogito.tracing.typedvalue.UnitValue;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LimeExplainerServiceHandlerTest {
    private static final String EXECUTION_ID = "executionId";
    private static final String SERVICE_URL = "serviceURL";
    private static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("resourceType", "resourceId");
    private static final ModelIdentifierDto MODEL_IDENTIFIER_DTO = new ModelIdentifierDto("resourceType", "resourceId");
    private LimeExplainer explainer;
    private LimeExplainerServiceHandler handler;

    @BeforeEach
    public void setup() {
        this.explainer = (LimeExplainer)Mockito.mock(LimeExplainer.class);
        this.handler = new LimeExplainerServiceHandler(this.explainer);
    }

    @Test
    public void testSupports() {
        Assertions.assertTrue((boolean)this.handler.supports(LIMEExplainabilityRequest.class));
        Assertions.assertFalse((boolean)this.handler.supports(BaseExplainabilityRequest.class));
    }

    @Test
    public void testSupportsDo() {
        Assertions.assertTrue((boolean)this.handler.supportsDto(LIMEExplainabilityRequestDto.class));
        Assertions.assertFalse((boolean)this.handler.supportsDto(BaseExplainabilityRequestDto.class));
    }

    @Test
    public void testExplainabilityRequestFrom() {
        LIMEExplainabilityRequestDto requestDto = new LIMEExplainabilityRequestDto(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER_DTO, Collections.emptyMap(), Collections.emptyMap());
        LIMEExplainabilityRequest request = this.handler.explainabilityRequestFrom(requestDto);
        Assertions.assertEquals((Object)requestDto.getExecutionId(), (Object)request.getExecutionId());
        Assertions.assertEquals((Object)requestDto.getServiceUrl(), (Object)request.getServiceUrl());
        Assertions.assertEquals((Object)requestDto.getModelIdentifier().getResourceId(), (Object)request.getModelIdentifier().getResourceId());
        Assertions.assertEquals((Object)requestDto.getModelIdentifier().getResourceType(), (Object)request.getModelIdentifier().getResourceType());
        Assertions.assertEquals((Object)requestDto.getInputs(), (Object)request.getInputs());
        Assertions.assertEquals((Object)requestDto.getOutputs(), (Object)request.getOutputs());
    }

    @Test
    public void testGetPredictionWithEmptyDefinition() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap());
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertTrue((boolean)prediction.getInput().getFeatures().isEmpty());
        Assertions.assertTrue((boolean)prediction.getOutput().getOutputs().isEmpty());
    }

    @Test
    public void testGetPredictionWithNonEmptyDefinition() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Map.of("input1", new UnitValue("number", (JsonNode)new IntNode(20)), "input2", new StructureValue("number", Map.of("input2b", new UnitValue("number", (JsonNode)new IntNode(55)))), "input3", new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100))))), Map.of("output1", new UnitValue("number", (JsonNode)new IntNode(20)), "output2", new StructureValue("number", Map.of("output2b", new UnitValue("number", (JsonNode)new IntNode(55)))), "output3", new CollectionValue("number", List.of(new UnitValue("number", (JsonNode)new IntNode(100))))));
        Prediction prediction = this.handler.getPrediction(request);
        Assertions.assertEquals((int)3, (int)prediction.getInput().getFeatures().size());
        Optional<Feature> oInput1 = prediction.getInput().getFeatures().stream().filter(f -> f.getName().equals("input1")).findFirst();
        Assertions.assertTrue((boolean)oInput1.isPresent());
        Feature input1 = oInput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)input1.getType());
        Assertions.assertEquals((double)20.0, (double)input1.getValue().asNumber());
        Optional<Feature> oInput2 = prediction.getInput().getFeatures().stream().filter(f -> f.getName().equals("input2")).findFirst();
        Assertions.assertTrue((boolean)oInput2.isPresent());
        Feature input2 = oInput2.get();
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)input2.getType());
        Assertions.assertTrue((boolean)(input2.getValue().getUnderlyingObject() instanceof List));
        List input2Object = (List)input2.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)input2Object.size());
        Optional<Feature> oInput2Child = input2Object.stream().filter(f -> f.getName().equals("input2b")).findFirst();
        Assertions.assertTrue((boolean)oInput2Child.isPresent());
        Feature input2Child = oInput2Child.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)input2Child.getType());
        Assertions.assertEquals((double)55.0, (double)input2Child.getValue().asNumber());
        Optional<Feature> oInput3 = prediction.getInput().getFeatures().stream().filter(f -> f.getName().equals("input3")).findFirst();
        Assertions.assertTrue((boolean)oInput3.isPresent());
        Feature input3 = oInput3.get();
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)input3.getType());
        Assertions.assertTrue((boolean)(input3.getValue().getUnderlyingObject() instanceof List));
        List input3Object = (List)input3.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)input3Object.size());
        Feature input3Child = (Feature)input3Object.get(0);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)input3Child.getType());
        Assertions.assertEquals((double)100.0, (double)input3Child.getValue().asNumber());
        Assertions.assertEquals((int)3, (int)prediction.getOutput().getOutputs().size());
        Optional<Output> oOutput1 = prediction.getOutput().getOutputs().stream().filter(o -> o.getName().equals("output1")).findFirst();
        Assertions.assertTrue((boolean)oOutput1.isPresent());
        Output output1 = oOutput1.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output1.getType());
        Assertions.assertEquals((double)20.0, (double)output1.getValue().asNumber());
        Optional<Output> oOutput2 = prediction.getOutput().getOutputs().stream().filter(o -> o.getName().equals("output2")).findFirst();
        Assertions.assertTrue((boolean)oOutput2.isPresent());
        Output output2 = oOutput2.get();
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)input2.getType());
        Assertions.assertTrue((boolean)(output2.getValue().getUnderlyingObject() instanceof List));
        List output2Object = (List)output2.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)output2Object.size());
        Optional<Output> oOutput2Child = output2Object.stream().filter(f -> f.getName().equals("output2b")).findFirst();
        Assertions.assertTrue((boolean)oOutput2Child.isPresent());
        Output output2Child = oOutput2Child.get();
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output2Child.getType());
        Assertions.assertEquals((double)55.0, (double)output2Child.getValue().asNumber());
        Optional<Output> oOutput3 = prediction.getOutput().getOutputs().stream().filter(o -> o.getName().equals("output3")).findFirst();
        Assertions.assertTrue((boolean)oOutput3.isPresent());
        Output output3 = oOutput3.get();
        Assertions.assertEquals((Object)Type.COMPOSITE, (Object)output3.getType());
        Assertions.assertTrue((boolean)(output3.getValue().getUnderlyingObject() instanceof List));
        List output3Object = (List)output3.getValue().getUnderlyingObject();
        Assertions.assertEquals((int)1, (int)output3Object.size());
        Output output3Child = (Output)output3Object.get(0);
        Assertions.assertEquals((Object)Type.NUMBER, (Object)output3Child.getType());
        Assertions.assertEquals((double)100.0, (double)output3Child.getValue().asNumber());
    }

    @Test
    public void testCreateSucceededResultDto() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap());
        Map<String, Saliency> saliencies = Map.of("s1", new Saliency(new Output("salary", Type.NUMBER), List.of(new FeatureImportance(new Feature("age", Type.NUMBER, new Value((Object)25.0)), 5.0), new FeatureImportance(new Feature("dependents", Type.NUMBER, new Value((Object)2)), -11.0))));
        BaseExplainabilityResultDto base = this.handler.createSucceededResultDto(request, saliencies);
        Assertions.assertTrue((boolean)(base instanceof LIMEExplainabilityResultDto));
        LIMEExplainabilityResultDto result = (LIMEExplainabilityResultDto)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.SUCCEEDED, (Object)result.getStatus());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
        Assertions.assertEquals((int)1, (int)result.getSaliencies().size());
        Assertions.assertTrue((boolean)result.getSaliencies().containsKey("s1"));
        SaliencyDto dto = (SaliencyDto)result.getSaliencies().get("s1");
        Assertions.assertEquals((int)2, (int)dto.getFeatureImportance().size());
        Assertions.assertEquals((Object)"age", (Object)((FeatureImportanceDto)dto.getFeatureImportance().get(0)).getFeatureName());
        Assertions.assertEquals((double)5.0, (Double)((FeatureImportanceDto)dto.getFeatureImportance().get(0)).getScore());
        Assertions.assertEquals((Object)"dependents", (Object)((FeatureImportanceDto)dto.getFeatureImportance().get(1)).getFeatureName());
        Assertions.assertEquals((double)-11.0, (Double)((FeatureImportanceDto)dto.getFeatureImportance().get(1)).getScore());
    }

    @Test
    public void testCreateFailedResultDto() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap());
        BaseExplainabilityResultDto base = this.handler.createFailedResultDto(request, (Throwable)new NullPointerException("Something went wrong"));
        Assertions.assertTrue((boolean)(base instanceof LIMEExplainabilityResultDto));
        LIMEExplainabilityResultDto result = (LIMEExplainabilityResultDto)base;
        Assertions.assertEquals((Object)ExplainabilityStatus.FAILED, (Object)result.getStatus());
        Assertions.assertEquals((Object)"Something went wrong", (Object)result.getStatusDetails());
        Assertions.assertEquals((Object)EXECUTION_ID, (Object)result.getExecutionId());
    }

    @Test
    public void testExplainAsyncDelegation() {
        Prediction prediction = (Prediction)Mockito.mock(Prediction.class);
        PredictionProvider model = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        this.handler.explainAsync(prediction, model);
        ((LimeExplainer)Mockito.verify((Object)this.explainer)).explainAsync((Prediction)ArgumentMatchers.eq((Object)prediction), (PredictionProvider)ArgumentMatchers.eq((Object)model));
    }
}

