/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import java.util.Collections;
import java.util.stream.Stream;
import javax.enterprise.inject.Instance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.explainability.api.BaseExplainabilityRequestDto;
import org.kie.kogito.explainability.api.CounterfactualExplainabilityRequestDto;
import org.kie.kogito.explainability.api.LIMEExplainabilityRequestDto;
import org.kie.kogito.explainability.api.ModelIdentifierDto;
import org.kie.kogito.explainability.handlers.CounterfactualExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LimeExplainerServiceHandler;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandlerRegistry;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.model.PredictionProvider;
import org.kie.kogito.explainability.models.BaseExplainabilityRequest;
import org.kie.kogito.explainability.models.CounterfactualExplainabilityRequest;
import org.kie.kogito.explainability.models.LIMEExplainabilityRequest;
import org.kie.kogito.explainability.models.ModelIdentifier;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class LocalExplainerServiceHandlerRegistryTest {
    private static final String EXECUTION_ID = "executionId";
    private static final String SERVICE_URL = "serviceURL";
    private static final ModelIdentifier MODEL_IDENTIFIER = new ModelIdentifier("resourceType", "resourceId");
    private static final ModelIdentifierDto MODEL_IDENTIFIER_DTO = new ModelIdentifierDto("resourceType", "resourceId");
    private static final String COUNTERFACTUAL_ID = "counterfactualId";
    private LimeExplainerServiceHandler limeExplainerServiceHandler;
    private CounterfactualExplainerServiceHandler counterfactualExplainerServiceHandler;
    private PredictionProvider predictionProvider;
    private LocalExplainerServiceHandlerRegistry registry;

    @BeforeEach
    public void setup() {
        LimeExplainer limeExplainer = (LimeExplainer)Mockito.mock(LimeExplainer.class);
        CounterfactualExplainer counterfactualExplainer = (CounterfactualExplainer)Mockito.mock(CounterfactualExplainer.class);
        this.limeExplainerServiceHandler = (LimeExplainerServiceHandler)Mockito.spy((Object)new LimeExplainerServiceHandler(limeExplainer));
        this.counterfactualExplainerServiceHandler = (CounterfactualExplainerServiceHandler)Mockito.spy((Object)new CounterfactualExplainerServiceHandler(counterfactualExplainer));
        this.predictionProvider = (PredictionProvider)Mockito.mock(PredictionProvider.class);
        Instance explanationHandlers = (Instance)Mockito.mock(Instance.class);
        Mockito.when((Object)explanationHandlers.stream()).thenReturn(Stream.of(this.limeExplainerServiceHandler, this.counterfactualExplainerServiceHandler));
        this.registry = new LocalExplainerServiceHandlerRegistry(explanationHandlers);
    }

    @Test
    public void testLIME_explainabilityRequestFrom() {
        LIMEExplainabilityRequestDto request = new LIMEExplainabilityRequestDto(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER_DTO, Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertTrue((boolean)(this.registry.explainabilityRequestFrom((BaseExplainabilityRequestDto)request) instanceof LIMEExplainabilityRequest));
        ((LimeExplainerServiceHandler)Mockito.verify((Object)this.limeExplainerServiceHandler)).explainabilityRequestFrom((LIMEExplainabilityRequestDto)ArgumentMatchers.eq((Object)request));
    }

    @Test
    public void testLIME_explainAsyncWithResults() {
        LIMEExplainabilityRequest request = new LIMEExplainabilityRequest(EXECUTION_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap());
        this.registry.explainAsyncWithResults((BaseExplainabilityRequest)request, this.predictionProvider);
        ((LimeExplainerServiceHandler)Mockito.verify((Object)this.limeExplainerServiceHandler)).explainAsyncWithResults((BaseExplainabilityRequest)((LIMEExplainabilityRequest)ArgumentMatchers.eq((Object)request)), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProvider));
    }

    @Test
    public void testCounterfactual_explainabilityRequestFrom() {
        CounterfactualExplainabilityRequestDto request = new CounterfactualExplainabilityRequestDto(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER_DTO, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        Assertions.assertTrue((boolean)(this.registry.explainabilityRequestFrom((BaseExplainabilityRequestDto)request) instanceof CounterfactualExplainabilityRequest));
        ((CounterfactualExplainerServiceHandler)Mockito.verify((Object)this.counterfactualExplainerServiceHandler)).explainabilityRequestFrom((CounterfactualExplainabilityRequestDto)ArgumentMatchers.eq((Object)request));
    }

    @Test
    public void testCounterfactual_explainAsyncWithResults() {
        CounterfactualExplainabilityRequest request = new CounterfactualExplainabilityRequest(EXECUTION_ID, COUNTERFACTUAL_ID, SERVICE_URL, MODEL_IDENTIFIER, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        this.registry.explainAsyncWithResults((BaseExplainabilityRequest)request, this.predictionProvider);
        ((CounterfactualExplainerServiceHandler)Mockito.verify((Object)this.counterfactualExplainerServiceHandler)).explainAsyncWithResults((BaseExplainabilityRequest)((CounterfactualExplainabilityRequest)ArgumentMatchers.eq((Object)request)), (PredictionProvider)ArgumentMatchers.eq((Object)this.predictionProvider));
    }
}

