/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability;

import com.fasterxml.jackson.databind.JsonNode;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.kie.kogito.explainability.api.CounterfactualDomainCategoricalDto;
import org.kie.kogito.explainability.api.CounterfactualDomainDto;
import org.kie.kogito.explainability.api.CounterfactualDomainRangeDto;
import org.kie.kogito.explainability.api.CounterfactualSearchDomainDto;
import org.kie.kogito.explainability.model.Feature;
import org.kie.kogito.explainability.model.FeatureFactory;
import org.kie.kogito.explainability.model.Output;
import org.kie.kogito.explainability.model.Type;
import org.kie.kogito.explainability.model.Value;
import org.kie.kogito.explainability.model.domain.CategoricalFeatureDomain;
import org.kie.kogito.explainability.model.domain.FeatureDomain;
import org.kie.kogito.explainability.model.domain.NumericalFeatureDomain;
import org.kie.kogito.tracing.typedvalue.CollectionValue;
import org.kie.kogito.tracing.typedvalue.TypedValue;

public class ConversionUtils {
    private ConversionUtils() {
    }

    protected static Feature toFeature(String name, Object value) {
        if (value instanceof JsonObject) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList((JsonObject)value));
        }
        return ConversionUtils.toTypeValuePair(value).map(p -> new Feature(name, (Type)p.getLeft(), (Value)p.getRight())).orElse(null);
    }

    public static Feature toFeature(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(value.toUnit().getValue()).map(p -> new Feature(name, (Type)p.getLeft(), (Value)p.getRight())).orElse(null);
        }
        if (value.isStructure()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(value.toStructure().getValue()));
        }
        if (value.isCollection()) {
            return FeatureFactory.newCompositeFeature((String)name, ConversionUtils.toFeatureList(name, value.toCollection()));
        }
        throw new IllegalArgumentException(String.format("unexpected value kind %s", value.getKind()));
    }

    public static FeatureDomain toFeatureDomain(String name, CounterfactualSearchDomainDto domain) {
        if (domain.isUnit()) {
            return ConversionUtils.toCounterfactualSearchDomain(domain.toUnit().getDomain()).orElse(null);
        }
        throw new IllegalArgumentException(String.format("Unsupported CounterfactualSearchDomain kind %s", domain.getKind()));
    }

    public static Boolean toFeatureConstraint(String name, CounterfactualSearchDomainDto domain) {
        if (domain.isUnit()) {
            return domain.toUnit().isFixed();
        }
        throw new IllegalArgumentException(String.format("Unsupported CounterfactualSearchDomain kind %s", domain.getKind()));
    }

    protected static List<Feature> toFeatureList(String name, CollectionValue collectionValue) {
        Collection values = collectionValue.getValue();
        ArrayList<Feature> list = new ArrayList<Feature>(values.size());
        int index = 0;
        for (TypedValue typedValue : values) {
            list.add(ConversionUtils.toFeature(name + "_" + index, typedValue));
            ++index;
        }
        return list;
    }

    public static List<Feature> toFeatureList(JsonObject mainObj) {
        return ConversionUtils.toList(mainObj, ConversionUtils::toFeature);
    }

    public static List<Feature> toFeatureList(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toFeature);
    }

    public static List<FeatureDomain> toFeatureDomainList(Map<String, CounterfactualSearchDomainDto> searchDomains) {
        return ConversionUtils.toList(searchDomains, ConversionUtils::toFeatureDomain);
    }

    public static List<Boolean> toFeatureConstraintList(Map<String, CounterfactualSearchDomainDto> searchDomains) {
        return ConversionUtils.toList(searchDomains, ConversionUtils::toFeatureConstraint);
    }

    public static <T> List<T> toList(JsonObject mainObj, BiFunction<String, Object, T> unitConverter) {
        if (mainObj == null) {
            return Collections.emptyList();
        }
        return mainObj.stream().map(entry -> unitConverter.apply((String)entry.getKey(), entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static <T, V> List<T> toList(Map<String, V> values, BiFunction<String, V, T> unitConverter) {
        if (values == null) {
            return Collections.emptyList();
        }
        return values.entrySet().stream().map(entry -> unitConverter.apply((String)entry.getKey(), entry.getValue())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static Output toOutput(String name, Object value) {
        if (value instanceof JsonObject) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputList((JsonObject)value)), 1.0);
        }
        return ConversionUtils.toTypeValuePair(value).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
    }

    public static Output toOutput(String name, TypedValue value) {
        if (value.isUnit()) {
            return ConversionUtils.toTypeValuePair(value.toUnit().getValue()).map(p -> new Output(name, (Type)p.getLeft(), (Value)p.getRight(), 1.0)).orElse(null);
        }
        if (value.isStructure()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputList(value.toStructure().getValue())), 1.0);
        }
        if (value.isCollection()) {
            return new Output(name, Type.COMPOSITE, new Value(ConversionUtils.toOutputList(name, value.toCollection())), 1.0);
        }
        return null;
    }

    protected static List<Output> toOutputList(String name, CollectionValue collectionValue) {
        Collection values = collectionValue.getValue();
        ArrayList<Output> list = new ArrayList<Output>(values.size());
        int index = 0;
        for (TypedValue typedValue : values) {
            list.add(ConversionUtils.toOutput(name + "_" + index, typedValue));
            ++index;
        }
        return list;
    }

    public static List<Output> toOutputList(JsonObject mainObj) {
        return ConversionUtils.toList(mainObj, ConversionUtils::toOutput);
    }

    public static List<Output> toOutputList(Map<String, TypedValue> values) {
        return ConversionUtils.toList(values, ConversionUtils::toOutput);
    }

    protected static Optional<Pair<Type, Value>> toTypeValuePair(Object value) {
        if (value instanceof Boolean) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value(value)));
        }
        if (value instanceof Number) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)((Number)value).doubleValue())));
        }
        if (value instanceof String) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value(value)));
        }
        return Optional.empty();
    }

    public static Optional<Pair<Type, Value>> toTypeValuePair(JsonNode jsonValue) {
        if (jsonValue.isBoolean()) {
            return Optional.of(Pair.of((Object)Type.BOOLEAN, (Object)new Value((Object)jsonValue.asBoolean())));
        }
        if (jsonValue.isNumber()) {
            return Optional.of(Pair.of((Object)Type.NUMBER, (Object)new Value((Object)jsonValue.asDouble())));
        }
        if (jsonValue.isTextual()) {
            return Optional.of(Pair.of((Object)Type.TEXT, (Object)new Value((Object)jsonValue.asText())));
        }
        return Optional.empty();
    }

    public static Optional<FeatureDomain> toCounterfactualSearchDomain(CounterfactualDomainDto domain) {
        if (domain instanceof CounterfactualDomainRangeDto) {
            CounterfactualDomainRangeDto range = (CounterfactualDomainRangeDto)domain;
            JsonNode lb = range.getLowerBound();
            JsonNode ub = range.getUpperBound();
            if (lb.isNumber() && ub.isNumber()) {
                return Optional.of(NumericalFeatureDomain.create((double)range.getLowerBound().asDouble(), (double)range.getUpperBound().asDouble()));
            }
            throw new IllegalArgumentException(String.format("Unsupported CounterfactualDomainRangeDto [%s, %s]", lb.asText(), ub.asText()));
        }
        if (domain instanceof CounterfactualDomainCategoricalDto) {
            CounterfactualDomainCategoricalDto categorical = (CounterfactualDomainCategoricalDto)domain;
            Collection jsonCategories = categorical.getCategories();
            CharSequence[] categories = new String[jsonCategories.size()];
            if (jsonCategories.stream().allMatch(JsonNode::isTextual)) {
                jsonCategories.stream().map(JsonNode::asText).collect(Collectors.toList()).toArray(categories);
                return Optional.of(CategoricalFeatureDomain.create((String[])categories));
            }
            throw new IllegalArgumentException(String.format("Unsupported CounterfactualDomainCategoricalDto [%s]", String.join((CharSequence)", ", categories)));
        }
        return Optional.empty();
    }
}

