/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualConfigurationFactory;
import org.kie.kogito.explainability.local.counterfactual.CounterfactualExplainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class CounterfactualExplainerProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CounterfactualExplainerProducer.class);
    private final Long maxRunningTimeSeconds;

    @Inject
    public CounterfactualExplainerProducer(@ConfigProperty(name="trusty.explainability.counterfactuals.maxRunningTimeSeconds", defaultValue="60") Integer maxRunningTimeSeconds) {
        this.maxRunningTimeSeconds = (long)maxRunningTimeSeconds;
    }

    @Produces
    public CounterfactualExplainer produce() {
        LOG.debug("CounterfactualExplainer created");
        return CounterfactualExplainer.builder().withSolverConfig(CounterfactualConfigurationFactory.builder().withSecondsSpentLimit(this.maxRunningTimeSeconds.longValue()).build()).build();
    }
}

