/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import java.security.SecureRandom;
import java.util.Random;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.explainability.local.lime.LimeConfig;
import org.kie.kogito.explainability.local.lime.LimeExplainer;
import org.kie.kogito.explainability.local.lime.optim.RecordingLimeExplainer;
import org.kie.kogito.explainability.model.PerturbationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LimeExplainerProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LimeExplainerProducer.class);
    private final Integer numberOfSamples;
    private final Integer numberOfPerturbations;
    private final Integer recordedPredictions;

    @Inject
    public LimeExplainerProducer(@ConfigProperty(name="trusty.explainability.numberOfSamples", defaultValue="100") Integer numberOfSamples, @ConfigProperty(name="trusty.explainability.numberOfPerturbations", defaultValue="1") Integer numberOfPerturbations, @ConfigProperty(name="trusty.explainability.recordedPredictions", defaultValue="10") Integer recordedPredictions) {
        this.numberOfSamples = numberOfSamples;
        this.numberOfPerturbations = numberOfPerturbations;
        this.recordedPredictions = recordedPredictions;
    }

    @Produces
    public LimeExplainer produce() {
        LOG.debug("LimeExplainer created (numberOfSamples={}, numberOfPerturbations={})", (Object)this.numberOfSamples, (Object)this.numberOfPerturbations);
        LimeConfig limeConfig = new LimeConfig().withSamples(this.numberOfSamples.intValue()).withPerturbationContext(new PerturbationContext((Random)new SecureRandom(), this.numberOfPerturbations.intValue()));
        return new RecordingLimeExplainer(limeConfig, this.recordedPredictions.intValue());
    }
}

