/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.explainability.handlers;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.kie.kogito.explainability.api.BaseExplainabilityRequest;
import org.kie.kogito.explainability.api.BaseExplainabilityResult;
import org.kie.kogito.explainability.handlers.LocalExplainerServiceHandler;

@ApplicationScoped
public class LocalExplainerServiceHandlerRegistry {
    public static final String SERVICE_HANDLER_NOT_FOUND_ERROR_MESSAGE = "LocalExplainerServiceHandler could not be found for '%s'";
    private Instance<LocalExplainerServiceHandler<?, ?>> explanationHandlers;

    protected LocalExplainerServiceHandlerRegistry() {
    }

    @Inject
    public LocalExplainerServiceHandlerRegistry(@Any Instance<LocalExplainerServiceHandler<?, ?>> explanationHandlers) {
        this.explanationHandlers = explanationHandlers;
    }

    public <R extends BaseExplainabilityRequest, S extends BaseExplainabilityResult> CompletableFuture<BaseExplainabilityResult> explainAsyncWithResults(R request, Consumer<S> intermediateResultsConsumer) {
        LocalExplainerServiceHandler<?, ?> explanationHandler = this.getLocalExplainer(request.getClass()).orElseThrow(() -> new IllegalArgumentException(String.format(SERVICE_HANDLER_NOT_FOUND_ERROR_MESSAGE, request.getClass().getName())));
        try {
            return explanationHandler.explainAsyncWithResults(this.cast(request), this.castConsumer(intermediateResultsConsumer));
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(explanationHandler.createFailedResult(this.cast(request), e));
        }
    }

    private <T extends BaseExplainabilityRequest> Optional<LocalExplainerServiceHandler<?, ?>> getLocalExplainer(Class<T> type) {
        return this.explanationHandlers.stream().filter(explainer -> explainer.supports(type)).findFirst();
    }

    private <T extends BaseExplainabilityRequest> T cast(BaseExplainabilityRequest type) {
        return (T)type;
    }

    private <S extends BaseExplainabilityResult> Consumer<S> castConsumer(Consumer<?> consumer) {
        return consumer;
    }
}

