/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.filesystem;

import java.nio.file.Paths;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;

public class FileSystemProcessInstancesTest {
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    @Test
    public void testBasicFlow() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((Iterable)process.instances().values()).hasSize(1);
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    private class FileSystemProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        FileSystemProcessInstancesFactory() {
            super(Paths.get("target", new String[0]));
        }

        public String path() {
            return "target";
        }
    }
}

