/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.filesystem;

import java.nio.file.Path;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.persistence.filesystem.FileSystemProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FileSystemProcessInstancesTest {
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    @Test
    public void testBasicFlow() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((Iterable)process.instances().values()).hasSize(1);
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceDescription"), (String)ArgumentMatchers.eq((Object)"User Task"));
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceStatus"), (String)ArgumentMatchers.eq((Object)"1"));
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)2))).remove((String)ArgumentMatchers.any());
    }

    @Test
    public void testBasicFlowWithStartFrom() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.startFrom("_2");
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).update((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)2))).remove((String)ArgumentMatchers.any());
    }

    @Test
    public void testBasicFlowControlledByUnitOfWork() {
        DefaultUnitOfWorkManager uowManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
        StaticProcessConfig config = new StaticProcessConfig((WorkItemHandlerConfig)new DefaultWorkItemHandlerConfig(), (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[0]), (UnitOfWorkManager)uowManager, null);
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((ProcessConfig)config, (Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        UnitOfWork uow = uowManager.newUnitOfWork();
        uow.start();
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((Iterable)process.instances().values()).hasSize(1);
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceDescription"), (String)ArgumentMatchers.eq((Object)"User Task"));
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceStatus"), (String)ArgumentMatchers.eq((Object)"1"));
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        uow = uowManager.newUnitOfWork();
        uow.start();
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)1))).remove((String)ArgumentMatchers.any());
    }

    private class FileSystemProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        private FileSystemProcessInstancesFactory() {
        }

        public FileSystemProcessInstances createProcessInstances(Process<?> process) {
            FileSystemProcessInstances instances = (FileSystemProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
            return instances;
        }

        public String path() {
            return "target";
        }
    }
}

