/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.impl.marshalling.ProcessInstanceMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemProcessInstances
implements MutableProcessInstances {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemProcessInstances.class);
    public static final String PI_DESCRIPTION = "ProcessInstanceDescription";
    public static final String PI_STATUS = "ProcessInstanceStatus";
    private Process<?> process;
    private Path storage;
    private ProcessInstanceMarshaller marshaller;

    public FileSystemProcessInstances(Process<?> process, Path storage) {
        this(process, storage, new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[0]));
    }

    public FileSystemProcessInstances(Process<?> process, Path storage, ProcessInstanceMarshaller marshaller) {
        this.process = process;
        this.storage = Paths.get(storage.toString(), process.id());
        this.marshaller = marshaller;
        try {
            Files.createDirectories(this.storage, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create directories for file based storage of process instances", e);
        }
    }

    public Optional findById(String id) {
        String resolvedId = this.resolveId(id);
        Path processInstanceStorage = Paths.get(this.storage.toString(), resolvedId);
        if (Files.notExists(processInstanceStorage, new LinkOption[0])) {
            return Optional.empty();
        }
        return Optional.of(this.marshaller.unmarshallProcessInstance(this.readBytesFromFile(processInstanceStorage), this.process));
    }

    public Collection values() {
        try {
            return Files.walk(this.storage, new FileVisitOption[0]).filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(f -> this.marshaller.unmarshallProcessInstance(this.readBytesFromFile((Path)f), this.process)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read process instances ", e);
        }
    }

    public boolean exists(String id) {
        return Files.exists(Paths.get(this.storage.toString(), this.resolveId(id)), new LinkOption[0]);
    }

    public void create(String id, ProcessInstance instance) {
        if (this.isActive(instance)) {
            String resolvedId = this.resolveId(id);
            Path processInstanceStorage = Paths.get(this.storage.toString(), resolvedId);
            if (Files.exists(processInstanceStorage, new LinkOption[0])) {
                throw new ProcessInstanceDuplicatedException(id);
            }
            this.storeProcessInstance(processInstanceStorage, instance);
        }
    }

    public void update(String id, ProcessInstance instance) {
        if (this.isActive(instance)) {
            String resolvedId = this.resolveId(id);
            Path processInstanceStorage = Paths.get(this.storage.toString(), resolvedId);
            if (Files.exists(processInstanceStorage, new LinkOption[0])) {
                this.storeProcessInstance(processInstanceStorage, instance);
            }
        }
    }

    public void remove(String id) {
        Path processInstanceStorage = Paths.get(this.storage.toString(), this.resolveId(id));
        try {
            Files.deleteIfExists(processInstanceStorage);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to remove process instance with id " + id, e);
        }
    }

    protected void storeProcessInstance(Path processInstanceStorage, ProcessInstance<?> instance) {
        try {
            byte[] data = this.marshaller.marshallProcessInstance(instance);
            Files.write(processInstanceStorage, data, new OpenOption[0]);
            this.setMetadata(processInstanceStorage, PI_DESCRIPTION, instance.description());
            this.setMetadata(processInstanceStorage, PI_STATUS, String.valueOf(instance.status()));
            this.disconnect(processInstanceStorage, instance);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to store process instance with id " + instance.id(), e);
        }
    }

    protected byte[] readBytesFromFile(Path processInstanceStorage) {
        try {
            return Files.readAllBytes(processInstanceStorage);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read process instance from " + processInstanceStorage, e);
        }
    }

    protected void disconnect(Path processInstanceStorage, ProcessInstance instance) {
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
            try {
                byte[] reloaded = this.readBytesFromFile(processInstanceStorage);
                return this.marshaller.unmarshallWorkflowProcessInstance(reloaded, this.process);
            }
            catch (RuntimeException e) {
                LOGGER.error("Unexpected exception thrown when reloading process instance {}", (Object)instance.id(), (Object)e);
                return null;
            }
        });
    }

    public String getMetadata(Path file, String key) {
        if (this.supportsUserDefinedAttributes(file)) {
            UserDefinedFileAttributeView view = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
            try {
                ByteBuffer bb = ByteBuffer.allocate(view.size(key));
                view.read(key, bb);
                bb.flip();
                return Charset.defaultCharset().decode(bb).toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public boolean setMetadata(Path file, String key, String value) {
        if (this.supportsUserDefinedAttributes(file)) {
            UserDefinedFileAttributeView view = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
            try {
                if (value != null) {
                    view.write(key, Charset.defaultCharset().encode(value));
                } else {
                    view.delete(key);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean supportsUserDefinedAttributes(Path file) {
        try {
            return Files.getFileStore(file).supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        catch (IOException e) {
            return false;
        }
    }
}

