/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.filesystem;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.persistence.filesystem.FileSystemProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.DefaultWorkItemHandlerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class FileSystemProcessInstancesTest {
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));

    FileSystemProcessInstancesTest() {
    }

    private BpmnProcess createProcess(ProcessConfig config, String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((ProcessConfig)config, (Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    @Test
    void testFindByIdReadMode() {
        BpmnProcess process = this.createProcess(null, "BPMN2-UserTask-Script.bpmn2");
        for (Node node : ((WorkflowProcess)process.process()).getNodes()) {
            if (!(node instanceof ActionNode)) continue;
            DroolsAction a = ((ActionNode)node).getAction();
            a.setMetaData("Action", kcontext -> {
                System.out.println("The variable value is " + kcontext.getVariable("s") + " about to call toString on it");
                kcontext.getVariable("s").toString();
            });
        }
        ProcessInstance mutablePi = process.createInstance(BpmnVariables.create(Collections.singletonMap("var", "value")));
        mutablePi.start();
        Assertions.assertThat((int)mutablePi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)mutablePi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).endsWith((CharSequence)"java.lang.NullPointerException - null");
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)mutablePi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ProcessInstance readOnlyPi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)readOnlyPi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).endsWith((CharSequence)"java.lang.NullPointerException - null");
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)readOnlyPi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> readOnlyPi.abort());
        ((ProcessInstance)instances.findById(mutablePi.id()).get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    @Test
    void testValuesReadMode() {
        BpmnProcess process = this.createProcess(null, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.values().stream().findFirst().get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ((ProcessInstance)instances.values(ProcessInstanceReadMode.MUTABLE).stream().findFirst().get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = this.createProcess(null, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        Assertions.assertThat((Integer)fileSystemBasedStorage.size()).isOne();
        Assertions.assertThat((boolean)fileSystemBasedStorage.exists(processInstance.id())).isTrue();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceDescription"), (String)ArgumentMatchers.eq((Object)"User Task"));
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceStatus"), (String)ArgumentMatchers.eq((Object)"1"));
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{this.securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)2))).remove(processInstance.id());
        Assertions.assertThat((Integer)fileSystemBasedStorage.size()).isZero();
    }

    @Test
    void testBasicFlowWithStartFrom() {
        BpmnProcess process = this.createProcess(null, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.startFrom("_2");
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).update((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage, (VerificationMode)Mockito.times((int)2))).remove((String)ArgumentMatchers.any());
        Assertions.assertThat((Integer)fileSystemBasedStorage.size()).isZero();
    }

    @Test
    void testBasicFlowControlledByUnitOfWork() {
        DefaultUnitOfWorkManager uowManager = new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory());
        StaticProcessConfig config = new StaticProcessConfig((WorkItemHandlerConfig)new DefaultWorkItemHandlerConfig(), (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[0]), (UnitOfWorkManager)uowManager, null);
        BpmnProcess process = this.createProcess((ProcessConfig)config, "BPMN2-UserTask.bpmn2");
        process.setProcessInstancesFactory((ProcessInstancesFactory)new FileSystemProcessInstancesFactory());
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        UnitOfWork uow = uowManager.newUnitOfWork();
        uow.start();
        processInstance.start();
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        FileSystemProcessInstances fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        Assertions.assertThat((boolean)fileSystemBasedStorage.exists(processInstance.id())).isTrue();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).create(processInstance.id(), processInstance);
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceDescription"), (String)ArgumentMatchers.eq((Object)"User Task"));
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).setMetadata((Path)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ProcessInstanceStatus"), (String)ArgumentMatchers.eq((Object)"1"));
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{this.securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat(workItem.getParameters().get("ActorId")).isEqualTo((Object)"john");
        uow = uowManager.newUnitOfWork();
        uow.start();
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        uow.end();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        fileSystemBasedStorage = (FileSystemProcessInstances)process.instances();
        ((FileSystemProcessInstances)Mockito.verify((Object)fileSystemBasedStorage)).remove(processInstance.id());
        Assertions.assertThat((Integer)fileSystemBasedStorage.size()).isZero();
    }

    private class FileSystemProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        private FileSystemProcessInstancesFactory() {
        }

        public FileSystemProcessInstances createProcessInstances(Process<?> process) {
            FileSystemProcessInstances instances = (FileSystemProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
            return instances;
        }

        public String path() {
            return "target";
        }
    }
}

