/*
 * Decompiled with CFR 0.152.
 */
package org.kie.flexible.kogito.example;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.flexible.kogito.example.model.Product;
import org.kie.flexible.kogito.example.model.State;
import org.kie.flexible.kogito.example.model.SupportCase;
import org.kie.flexible.kogito.example.service.TriageService;
import org.kie.kogito.tests.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class ServiceDeskProcessTest {
    @LocalServerPort
    int port;
    private static final String BASE_PATH = "/serviceDesk";

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testSupportCaseExample() {
        String id = this.createSupportCase();
        this.addSupportComment(id);
        this.addCustomerComment(id);
        this.resolveCase(id);
        this.sendQuestionnaire(id);
        this.checkAllProcessesFinished();
    }

    private String createSupportCase() {
        SupportCase supportCase = new SupportCase().setProduct(new Product().setFamily("Middleware").setName("Kogito")).setCustomer("Paco").setDescription("Something is not working");
        HashMap<String, SupportCase> params = new HashMap<String, SupportCase>();
        params.put("supportCase", supportCase);
        return (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).when().body(params).post(BASE_PATH, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_OWNER.name()), new Object[0])).body("supportCase.engineer", (Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{CoreMatchers.is((Object)TriageService.KOGITO_ENGINEERS[0]), CoreMatchers.is((Object)TriageService.KOGITO_ENGINEERS[1])}), new Object[0])).body("supportGroup", CoreMatchers.is((Object)"Kogito"), new Object[0])).extract().path("id", new String[0]);
    }

    private void addSupportComment(String id) {
        String link = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().post("/ReceiveSupportComment", new Object[0])).then()).statusCode(200)).header("Link", CoreMatchers.notNullValue())).extract().header("Link");
        String taskPath = link.substring(1, link.indexOf(">"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "Have you tried to turn it off and on again?");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath(BASE_PATH).queryParam("user", new Object[]{"kelly"}).queryParam("group", new Object[]{"support"}).contentType(ContentType.JSON).when().body(params).post(taskPath, new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_CUSTOMER.name()), new Object[0])).body("supportCase.comments[0].text", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.comments[0].author", CoreMatchers.is((Object)"kelly"), new Object[0])).body("supportCase.comments[0].date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void addCustomerComment(String id) {
        String link = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().post("/ReceiveCustomerComment", new Object[0])).then()).statusCode(200)).header("Link", CoreMatchers.notNullValue())).extract().header("Link");
        String taskPath = link.substring(1, link.indexOf(">"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("comment", "Great idea!");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath(BASE_PATH).queryParam("user", new Object[]{"Paco"}).queryParam("group", new Object[]{"customer"}).contentType(ContentType.JSON).when().body(params).post(taskPath, new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.WAITING_FOR_OWNER.name()), new Object[0])).body("supportCase.comments[1].text", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.comments[1].author", CoreMatchers.is((Object)"Paco"), new Object[0])).body("supportCase.comments[1].date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void resolveCase(String id) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().post("/Resolve_Case", new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.RESOLVED.name()), new Object[0]);
    }

    private void sendQuestionnaire(String id) {
        Map tasks = (Map)((Response)RestAssured.given().basePath("/serviceDesk/" + id).contentType(ContentType.JSON).when().get("/tasks", new Object[0])).as(Map.class);
        Assertions.assertEquals((int)1, (int)tasks.size());
        Assertions.assertTrue((boolean)tasks.values().contains("Questionnaire"));
        Optional<String> taskId = tasks.entrySet().stream().filter(e -> ((String)e.getValue()).equals("Questionnaire")).map(Map.Entry::getKey).findFirst();
        Assertions.assertTrue((boolean)taskId.isPresent());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("comment", "Kogito is great!");
        params.put("evaluation", 10);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().basePath("/serviceDesk/" + id).queryParam("user", new Object[]{"Paco"}).queryParam("group", new Object[]{"customer"}).contentType(ContentType.JSON).when().body(params).post("/Questionnaire/" + taskId.get(), new Object[0])).then()).statusCode(200)).body("supportCase.state", CoreMatchers.is((Object)State.CLOSED.name()), new Object[0])).body("supportCase.questionnaire.comment", CoreMatchers.is(params.get("comment")), new Object[0])).body("supportCase.questionnaire.evaluation", CoreMatchers.is(params.get("evaluation")), new Object[0])).body("supportCase.questionnaire.date", CoreMatchers.notNullValue(), new Object[0]);
    }

    private void checkAllProcessesFinished() {
        List processes = (List)((Response)RestAssured.given().basePath(BASE_PATH).contentType(ContentType.JSON).when().get("/", new Object[0])).as(List.class);
        Assertions.assertTrue((boolean)processes.isEmpty());
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }
}

