/*
 * Decompiled with CFR 0.152.
 */
package org.kie.flexible.kogito.example;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.api.runtime.process.WorkItemNotFoundException;
import org.kie.flexible.kogito.example.ServiceDeskModel;
import org.kie.flexible.kogito.example.ServiceDeskModelInput;
import org.kie.flexible.kogito.example.ServiceDeskModelOutput;
import org.kie.flexible.kogito.example.ServiceDesk_11_TaskInput;
import org.kie.flexible.kogito.example.ServiceDesk_11_TaskOutput;
import org.kie.flexible.kogito.example.ServiceDesk_14_TaskInput;
import org.kie.flexible.kogito.example.ServiceDesk_14_TaskOutput;
import org.kie.flexible.kogito.example.ServiceDesk_16_TaskInput;
import org.kie.flexible.kogito.example.ServiceDesk_16_TaskOutput;
import org.kie.flexible.kogito.example.ServiceDesk_17_TaskInput;
import org.kie.flexible.kogito.example.ServiceDesk_17_TaskOutput;
import org.kie.kogito.Application;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/serviceDesk")
@Component
public class ServiceDeskResource {
    @Autowired
    @Qualifier(value="serviceDesk")
    Process<ServiceDeskModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ServiceDeskModelOutput createResource_serviceDesk(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull ServiceDeskModelInput resource) {
        if (resource == null) {
            resource = new ServiceDeskModelInput();
        }
        ServiceDeskModelInput value = resource;
        return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)this.mapInput(value, new ServiceDeskModel()));
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return this.getModel(pi);
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<ServiceDeskModelOutput> getResources_serviceDesk() {
        return this.process.instances().values().stream().map(pi -> this.mapOutput(new ServiceDeskModelOutput(), (ServiceDeskModel)pi.variables())).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput getResource_serviceDesk(@PathParam(value="id") String id) {
        return this.process.instances().findById(id).map(pi -> this.mapOutput(new ServiceDeskModelOutput(), (ServiceDeskModel)pi.variables())).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput deleteResource_serviceDesk(@PathParam(value="id") String id) {
        return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.abort();
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput updateModel_serviceDesk(@PathParam(value="id") String id, ServiceDeskModel resource) {
        return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.updateVariables((Object)resource);
            return this.mapOutput(new ServiceDeskModelOutput(), (ServiceDeskModel)pi.variables());
        });
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_serviceDesk(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected ServiceDeskModelOutput getModel(ProcessInstance<ServiceDeskModel> pi) {
        if (pi.status() == 5 && pi.error().isPresent()) {
            throw new ProcessInstanceExecutionException(pi.id(), ((ProcessError)pi.error().get()).failedNodeId(), ((ProcessError)pi.error().get()).errorMessage());
        }
        return this.mapOutput(new ServiceDeskModelOutput(), (ServiceDeskModel)pi.variables());
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    protected ServiceDeskModel mapInput(@Valid @NotNull ServiceDeskModelInput input, ServiceDeskModel resource) {
        resource.fromMap(input.toMap());
        return resource;
    }

    protected ServiceDeskModelOutput mapOutput(ServiceDeskModelOutput output, ServiceDeskModel resource) {
        output.fromMap(resource.getId(), resource.toMap());
        return output;
    }

    @POST
    @Path(value="/{id}/Resolve_Case")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput signal_0(@PathParam(value="id") String id) {
        return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of((String)"Resolve Case", null));
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}/CaseResolved")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput signal_1(@PathParam(value="id") String id) {
        return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of((String)"CaseResolved", null));
            return this.getModel(pi);
        });
    }

    @POST
    @Path(value="/{id}/ManualAssignment/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput completeTask_ManualAssignment_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, ServiceDesk_11_TaskOutput model) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ManualAssignment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDesk_11_TaskInput getTask_ManualAssignment_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_11_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="ManualAssignment/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ManualAssignment_2() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManualAssignment");
    }

    @GET
    @Path(value="/{id}/ManualAssignment/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ManualAssignment_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ManualAssignment"));
    }

    @DELETE
    @Path(value="/{id}/ManualAssignment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput abortTask_ManualAssignment_2(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path(value="/{id}/Questionnaire/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput completeTask_Questionnaire_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, ServiceDesk_14_TaskOutput model) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/Questionnaire/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDesk_14_TaskInput getTask_Questionnaire_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_14_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="Questionnaire/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_Questionnaire_3() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"Questionnaire");
    }

    @GET
    @Path(value="/{id}/Questionnaire/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_Questionnaire_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"Questionnaire"));
    }

    @DELETE
    @Path(value="/{id}/Questionnaire/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput abortTask_Questionnaire_3(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path(value="/{id}/ReceiveCustomerComment")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response signal_ReceiveCustomerComment_4(@PathParam(value="id") String id) {
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of((String)"Receive customer comment", Collections.emptyMap()));
            Optional<WorkItem> task = pi.workItems(new Policy[0]).stream().filter(wi -> wi.getName().equals("ReceiveCustomerComment")).findFirst();
            if (task.isPresent()) {
                return Response.ok((Object)this.getModel(pi)).header("Link", (Object)("</" + id + "/ReceiveCustomerComment/" + task.get().getId() + ">; rel='instance'")).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    @POST
    @Path(value="/{id}/ReceiveCustomerComment/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput completeTask_ReceiveCustomerComment_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, ServiceDesk_16_TaskOutput model) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDesk_16_TaskInput getTask_ReceiveCustomerComment_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_16_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="ReceiveCustomerComment/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ReceiveCustomerComment_4() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ReceiveCustomerComment");
    }

    @GET
    @Path(value="/{id}/ReceiveCustomerComment/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ReceiveCustomerComment_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ReceiveCustomerComment"));
    }

    @DELETE
    @Path(value="/{id}/ReceiveCustomerComment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput abortTask_ReceiveCustomerComment_4(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @POST
    @Path(value="/{id}/ReceiveSupportComment")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response signal_ReceiveSupportComment_5(@PathParam(value="id") String id) {
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            pi.send(Sig.of((String)"Receive support comment", Collections.emptyMap()));
            Optional<WorkItem> task = pi.workItems(new Policy[0]).stream().filter(wi -> wi.getName().equals("ReceiveSupportComment")).findFirst();
            if (task.isPresent()) {
                return Response.ok((Object)this.getModel(pi)).header("Link", (Object)("</" + id + "/ReceiveSupportComment/" + task.get().getId() + ">; rel='instance'")).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    @POST
    @Path(value="/{id}/ReceiveSupportComment/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput completeTask_ReceiveSupportComment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, ServiceDesk_17_TaskOutput model) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, model.toMap(), (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDesk_17_TaskInput getTask_ReceiveSupportComment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            ProcessInstance pi = this.process.instances().findById(id).orElse(null);
            if (pi == null) {
                return null;
            }
            WorkItem workItem = pi.workItem(workItemId, this.policies(user, groups));
            if (workItem == null) {
                return null;
            }
            return ServiceDesk_17_TaskInput.fromMap((String)workItem.getId(), (String)workItem.getName(), (Map)workItem.getParameters());
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }

    @GET
    @Path(value="ReceiveSupportComment/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ReceiveSupportComment_5() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ReceiveSupportComment");
    }

    @GET
    @Path(value="/{id}/ReceiveSupportComment/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ReceiveSupportComment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ReceiveSupportComment"));
    }

    @DELETE
    @Path(value="/{id}/ReceiveSupportComment/{workItemId}")
    @Produces(value={"application/json"})
    public ServiceDeskModelOutput abortTask_ReceiveSupportComment_5(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        try {
            return (ServiceDeskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
                ProcessInstance pi = this.process.instances().findById(id).orElse(null);
                if (pi == null) {
                    return null;
                }
                StaticIdentityProvider identity = null;
                if (user != null) {
                    identity = new StaticIdentityProvider(user, groups);
                }
                HumanTaskTransition transition = new HumanTaskTransition(phase, null, (IdentityProvider)identity);
                pi.transitionWorkItem(workItemId, (Transition)transition);
                return this.getModel(pi);
            });
        }
        catch (WorkItemNotFoundException e) {
            return null;
        }
    }
}

