/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.utils;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.grafana.utils.GrafanaDashboardUtils;

class GrafanaDashboardUtilsTest {
    GrafanaDashboardUtilsTest() {
    }

    @Test
    void isOperationDashboardEnabled() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello"));
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", "");
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello"));
        String values = "Hello";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello"));
        values = "Hello,Loan";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Traffic"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello"));
        values = " Hello, Loan ";
        propertiesMap.put("kogito.grafana.disabled.operational.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Traffic"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isOperationDashboardEnabled(propertiesMap, (String)"Hello"));
    }

    @Test
    void isDomainDashboardEnabled() {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello"));
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", "");
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello"));
        String values = "Hello";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello"));
        values = "Hello,Loan";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Traffic"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello"));
        values = " Hello, Loan ";
        propertiesMap.put("kogito.grafana.disabled.domain.dashboards", values);
        Assertions.assertTrue((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Traffic"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Loan"));
        Assertions.assertFalse((boolean)GrafanaDashboardUtils.isDomainDashboardEnabled(propertiesMap, (String)"Hello"));
    }
}

