/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana;

import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.grafana.GrafanaConfigurationWriter;

public class GrafanaConfigurationWriterTest {
    @Test
    public void testGrafanaDashboardName() {
        KogitoGAV gav = new KogitoGAV("groupId", "artifactId", "versionId");
        String handlerName = "myHandler";
        String expected = "artifactId_versionId - myHandler";
        String dashboardName = GrafanaConfigurationWriter.buildDashboardName(Optional.of(gav), (String)handlerName);
        Assertions.assertEquals((Object)expected, (Object)dashboardName);
    }

    @Test
    public void testGrafanaDashboardNameWithEmptyGav() {
        String handlerName = "myHandler";
        String expected = "myHandler";
        String dashboardName = GrafanaConfigurationWriter.buildDashboardName(Optional.empty(), (String)handlerName);
        Assertions.assertEquals((Object)expected, (Object)dashboardName);
    }
}

