/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.grafana.factories;

import java.util.List;
import org.kie.kogito.grafana.factories.GridPosFactory;
import org.kie.kogito.grafana.factories.TargetFactory;
import org.kie.kogito.grafana.model.panel.GaugePanel;
import org.kie.kogito.grafana.model.panel.GrafanaPanel;
import org.kie.kogito.grafana.model.panel.PanelType;
import org.kie.kogito.grafana.model.panel.common.YAxis;
import org.kie.kogito.grafana.model.panel.graph.GraphPanel;
import org.kie.kogito.grafana.model.panel.heatmap.HeatMapPanel;
import org.kie.kogito.grafana.model.panel.stat.SingleStatPanel;
import org.kie.kogito.grafana.model.panel.stat.StatPanel;
import org.kie.kogito.grafana.model.panel.table.TablePanel;

public class PanelFactory {
    private PanelFactory() {
    }

    public static GrafanaPanel createPanel(PanelType type, int id, String title, String expr, List<YAxis> yaxes) {
        switch (type) {
            case GRAPH: {
                return PanelFactory.createGraph(id, title, expr, yaxes);
            }
            case STAT: {
                return PanelFactory.createStat(id, title, expr);
            }
            case HEATMAP: {
                return PanelFactory.createHeartMap(id, title, expr);
            }
            case SINGLESTAT: {
                return PanelFactory.createSingleStat(id, title, expr);
            }
            case TABLE: {
                return PanelFactory.createTable(id, title, expr);
            }
            case GAUGE: {
                return PanelFactory.createGauge(id, title, expr);
            }
        }
        throw new UnsupportedOperationException("The panel " + type.toString() + " is not supported.");
    }

    static GrafanaPanel createGraph(int id, String title, String expr, List<YAxis> yaxes) {
        return new GraphPanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr), yaxes);
    }

    static GrafanaPanel createStat(int id, String title, String expr) {
        return new StatPanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr));
    }

    static GrafanaPanel createHeartMap(int id, String title, String expr) {
        return new HeatMapPanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr));
    }

    static GrafanaPanel createSingleStat(int id, String title, String expr) {
        return new SingleStatPanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr));
    }

    static GrafanaPanel createGauge(int id, String title, String expr) {
        return new GaugePanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr));
    }

    static GrafanaPanel createTable(int id, String title, String expr) {
        return new TablePanel(id, title, GridPosFactory.calculateGridPosById(id), TargetFactory.createTargets(expr));
    }
}

