/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.kogito.infinispan.ProtoStreamObjectMarshallingStrategy;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.impl.marshalling.ProcessInstanceMarshaller;

public class CacheProcessInstances
implements MutableProcessInstances {
    private final RemoteCache<String, byte[]> cache;
    private ProcessInstanceMarshaller marshaller;
    private Process<?> process;

    public CacheProcessInstances(Process<?> process, RemoteCacheManager cacheManager, String templateName, String proto, BaseMarshaller<?> ... marshallers) {
        this.process = process;
        this.cache = cacheManager.administration().getOrCreateCache(process.id() + "_store", this.ignoreNullOrEmpty(templateName));
        this.marshaller = new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[]{new ProtoStreamObjectMarshallingStrategy(proto, marshallers)});
    }

    public Integer size() {
        return this.cache.size();
    }

    public Optional<? extends ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        byte[] data = (byte[])this.cache.get((Object)this.resolveId(id));
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(data, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(data, this.process));
    }

    public Collection<? extends ProcessInstance> values(ProcessInstanceReadMode mode) {
        return this.cache.values().parallelStream().map(data -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(data, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(data, this.process)).collect(Collectors.toList());
    }

    public void update(String id, ProcessInstance instance) {
        this.updateStorage(id, instance, false);
    }

    public void remove(String id) {
        this.cache.remove((Object)this.resolveId(id));
    }

    protected String ignoreNullOrEmpty(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public void create(String id, ProcessInstance instance) {
        this.updateStorage(id, instance, true);
    }

    protected void updateStorage(String id, ProcessInstance instance, boolean checkDuplicates) {
        if (this.isActive(instance)) {
            String resolvedId = this.resolveId(id);
            byte[] data = this.marshaller.marshallProcessInstance(instance);
            if (checkDuplicates) {
                byte[] existing = (byte[])this.cache.putIfAbsent((Object)resolvedId, (Object)data);
                if (existing != null) {
                    throw new ProcessInstanceDuplicatedException(id);
                }
            } else {
                this.cache.put((Object)resolvedId, (Object)data);
            }
            ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
                byte[] reloaded = (byte[])this.cache.get((Object)resolvedId);
                if (reloaded != null) {
                    return this.marshaller.unmarshallWorkflowProcessInstance(reloaded, this.process);
                }
                return null;
            });
        }
    }

    public boolean exists(String id) {
        return this.cache.containsKey((Object)id);
    }
}

