/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.EnumMarshaller;
import org.jbpm.workflow.core.impl.WorkflowProcessImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.Model;
import org.kie.kogito.infinispan.CacheProcessInstances;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.persistence.protobuf.marshallers.BooleanMessageMarshaller;
import org.kie.kogito.persistence.protobuf.marshallers.StringMessageMarshaller;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcess;
import org.mockito.Mockito;

class KogitoProcessInstancesFactoryTest {
    KogitoProcessInstancesFactoryTest() {
    }

    @Test
    void testCreate() {
        RemoteCacheManager cacheManager = (RemoteCacheManager)Mockito.mock(RemoteCacheManager.class);
        Mockito.when((Object)cacheManager.administration()).thenReturn((Object)((RemoteCacheManagerAdmin)Mockito.mock(RemoteCacheManagerAdmin.class)));
        final ArrayList myMarshallers = new ArrayList();
        KogitoProcessInstancesFactory factory = new KogitoProcessInstancesFactory(cacheManager){

            public List<BaseMarshaller<?>> marshallers() {
                return myMarshallers;
            }
        };
        MyProcessImpl myProcess = new MyProcessImpl();
        CacheProcessInstances instances = factory.createProcessInstances((org.kie.kogito.process.Process)myProcess);
        Assertions.assertNotNull((Object)instances);
        Assertions.assertEquals(myMarshallers, (Object)factory.marshallers());
    }

    List<BaseMarshaller<?>> getMarshallers() {
        ArrayList marshallers = new ArrayList();
        marshallers.add((BaseMarshaller<?>)new TheEnumMarshaller());
        marshallers.add((BaseMarshaller<?>)new BooleanMessageMarshaller());
        marshallers.add((BaseMarshaller<?>)new StringMessageMarshaller());
        return marshallers;
    }

    private static class TheEnumMarshaller
    implements EnumMarshaller<TheEnum> {
        private TheEnumMarshaller() {
        }

        public TheEnum decode(int enumValue) {
            return null;
        }

        public int encode(TheEnum theEnum) throws IllegalArgumentException {
            return 0;
        }

        public Class<? extends TheEnum> getJavaClass() {
            return null;
        }

        public String getTypeName() {
            return null;
        }
    }

    private static enum TheEnum {
        YES,
        NO;

    }

    private static class MyProcessImpl
    extends AbstractProcess<Model> {
        private MyProcessImpl() {
        }

        public ProcessInstance<Model> createInstance(WorkflowProcessInstance wpi) {
            return null;
        }

        public ProcessInstance<Model> createReadOnlyInstance(WorkflowProcessInstance wpi) {
            return null;
        }

        public Process process() {
            return new WorkflowProcessImpl();
        }

        public ProcessInstance<Model> createInstance(Model workingMemory) {
            return null;
        }
    }
}

