/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collections;
import java.util.List;
import org.drools.core.io.impl.ClassPathResource;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;

@Disabled(value="Requires running Infinispan instance")
public class CacheProcessInstancesTest {
    @Test
    public void testBasicFlow() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(11222);
        RemoteCacheManager cacheManager = new RemoteCacheManager(builder.build());
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource)new ClassPathResource("BPMN2-UserTask.bpmn2")).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertEquals((int)1, (int)processInstance.status());
        WorkItem workItem = (WorkItem)processInstance.workItems().get(0);
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", workItem.getParameters().get("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), null);
        Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    private class CacheProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        CacheProcessInstancesFactory(RemoteCacheManager cacheManager) {
            super(cacheManager);
        }

        public String proto() {
            return null;
        }

        public List<?> marshallers() {
            return Collections.emptyList();
        }
    }
}

