/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.protostream.MessageMarshaller;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.kogito.infinispan.ProtoStreamObjectMarshallingStrategy;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.impl.marshalling.ProcessInstanceMarshaller;

public class CacheProcessInstances
implements MutableProcessInstances {
    private final RemoteCache<String, byte[]> cache;
    private ProcessInstanceMarshaller marshaller;
    private Process<?> process;

    public CacheProcessInstances(Process<?> process, RemoteCacheManager cacheManager, String templateName, String proto, MessageMarshaller<?> ... marshallers) {
        this.process = process;
        this.cache = cacheManager.administration().getOrCreateCache(process.id() + "_store", this.ignoreNullOrEmpty(templateName));
        this.marshaller = new ProcessInstanceMarshaller(new ObjectMarshallingStrategy[]{new ProtoStreamObjectMarshallingStrategy(proto, marshallers)});
    }

    public Optional<? extends ProcessInstance> findById(String id) {
        byte[] data = (byte[])this.cache.get((Object)id);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(this.marshaller.unmarshallProcessInstance(data, this.process));
    }

    public Collection<? extends ProcessInstance> values() {
        return this.cache.values().parallelStream().map(data -> this.marshaller.unmarshallProcessInstance(data, this.process)).collect(Collectors.toList());
    }

    public void update(String id, ProcessInstance instance) {
        if (this.isActive(instance)) {
            byte[] data = this.marshaller.marhsallProcessInstance(instance);
            this.cache.put((Object)instance.id(), (Object)data);
            ((AbstractProcessInstance)instance).internalRemoveProcessInstance(() -> {
                byte[] reloaded = (byte[])this.cache.get((Object)id);
                if (reloaded != null) {
                    return ((AbstractProcessInstance)this.marshaller.unmarshallProcessInstance(reloaded, this.process, (AbstractProcessInstance)instance)).internalGetProcessInstance();
                }
                return null;
            });
        }
    }

    public void remove(String id) {
        this.cache.remove((Object)id);
    }

    protected String ignoreNullOrEmpty(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }
}

