/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.testcontainers;

import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.kie.kogito.resources.TestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class JobServiceContainer
extends GenericContainer<JobServiceContainer>
implements TestResource {
    public static final String NAME = "jobs-service";
    public static final int PORT = 8080;
    public static final String IMAGE = "container.image.jobs-service";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServiceContainer.class);

    public JobServiceContainer() {
        this.addExposedPort(8080);
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Listening on:.*", (int)1));
        this.setDockerImageName(this.getImageName());
    }

    public int getMappedPort() {
        return this.getMappedPort(8080);
    }

    public String getResourceName() {
        return NAME;
    }

    private String getImageName() {
        return Optional.ofNullable(System.getProperty(IMAGE)).filter(StringUtils::isNotBlank).orElseThrow(() -> new IllegalArgumentException("container.image.jobs-service property should be set in pom.xml"));
    }
}

