/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HelloService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloService.class);

    public String hello(String name) {
        HelloService.logMethodCall("hello", name);
        return "Hello " + name + "!";
    }

    public JsonNode jsonHello(JsonNode person) {
        HelloService.logMethodCall("jsonHello", person);
        String retJsonStr = "{\"result\":\"Hello " + person.get("name").textValue() + "\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(retJsonStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String goodbye(String name) {
        HelloService.logMethodCall("goodbye", name);
        return "Goodbye " + name + "!";
    }

    public String helloMulti(String name, String lastName) {
        HelloService.logMethodCall("helloMulti", name, lastName);
        return "Hello (first and lastname) " + name.concat(" ").concat(lastName).concat("!");
    }

    public void helloNoOutput(String name, Integer age) {
        HelloService.logMethodCall("helloNoOutput", name, age);
    }

    public String helloOutput(String name, Integer age) {
        HelloService.logMethodCall("helloOutput", name, age);
        return "Hello " + name.concat(" ").concat(String.valueOf(age)).concat("!");
    }

    private static void logMethodCall(String method, Object ... arguments) {
        LOGGER.info("HelloService.{} invoked with params: {}", (Object)method, (Object)arguments);
    }
}

