/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.flow.migration.DummyProcess;
import org.jbpm.flow.migration.MigrationPlanService;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.kie.api.definition.process.Process;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.Processes;
import org.mockito.Mockito;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class MigrationPlanServiceTest {
    Processes processes;
    org.kie.kogito.process.Process processB;

    @BeforeAll
    public void init() {
        this.processes = (Processes)Mockito.mock(Processes.class);
        Mockito.when((Object)this.processes.processIds()).thenReturn(Collections.singletonList("process_B"));
        this.processB = (org.kie.kogito.process.Process)Mockito.mock(org.kie.kogito.process.Process.class);
        Mockito.when((Object)this.processes.processById("process_B")).thenReturn((Object)this.processB);
        Mockito.when((Object)this.processB.id()).thenReturn((Object)"process_B");
        Mockito.when((Object)this.processB.version()).thenReturn((Object)"2");
    }

    @Test
    public void testMigrationProcessInstanceSameProcessDefinition() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setInternalProcess((Process)new DummyProcess("process_A", "1"));
        processImpl.setProcessId("process_A");
        processImpl.setProcessVersion("1");
        service.migrateProcessElement(this.processes, (KogitoWorkflowProcessInstance)processImpl);
        ((ObjectAssert)Assertions.assertThat((Object)processImpl).hasFieldOrPropertyWithValue("processId", (Object)"process_A")).hasFieldOrPropertyWithValue("processVersion", (Object)"1");
    }

    @Test
    public void testMigrationProcessInstance() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setInternalProcess((Process)new DummyProcess("process_B", "2"));
        processImpl.setProcessId("process_A");
        processImpl.setProcessVersion("1");
        service.migrateProcessElement(this.processes, (KogitoWorkflowProcessInstance)processImpl);
        ((ObjectAssert)Assertions.assertThat((Object)processImpl).hasFieldOrPropertyWithValue("processId", (Object)"process_B")).hasFieldOrPropertyWithValue("processVersion", (Object)"2");
    }

    @Test
    public void testMigrationProcessInstanceNotMatchingVersion() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setProcess((Process)new DummyProcess("process_D", "1"));
        service.migrateProcessElement(this.processes, (KogitoWorkflowProcessInstance)processImpl);
        ((ObjectAssert)Assertions.assertThat((Object)processImpl).hasFieldOrPropertyWithValue("processId", (Object)"process_D")).hasFieldOrPropertyWithValue("processVersion", (Object)"1");
    }

    @Test
    public void testMigrationProcessNonExisting() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setProcess((Process)new DummyProcess("process_C", "1"));
        service.migrateProcessElement(this.processes, (KogitoWorkflowProcessInstance)processImpl);
        ((ObjectAssert)Assertions.assertThat((Object)processImpl).hasFieldOrPropertyWithValue("processId", (Object)"process_C")).hasFieldOrPropertyWithValue("processVersion", (Object)"1");
    }

    @Test
    public void testMigrationProcessNotRightVersion() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setProcess((Process)new DummyProcess("process_A", "3"));
        service.migrateProcessElement(this.processes, (KogitoWorkflowProcessInstance)processImpl);
        ((ObjectAssert)Assertions.assertThat((Object)processImpl).hasFieldOrPropertyWithValue("processId", (Object)"process_A")).hasFieldOrPropertyWithValue("processVersion", (Object)"3");
    }

    @Test
    public void testMigrationNode() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setInternalProcess((Process)new DummyProcess("process_B", "2"));
        processImpl.setProcessId("process_A");
        processImpl.setProcessVersion("1");
        ExtendedNodeInstanceImpl nodeInstanceImpl = new ExtendedNodeInstanceImpl(){};
        nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processImpl);
        nodeInstanceImpl.setNodeId(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_1"));
        service.migrateNodeElement(this.processes, (KogitoNodeInstance)nodeInstanceImpl);
        Assertions.assertThat((Object)nodeInstanceImpl).hasFieldOrPropertyWithValue("nodeId", (Object)WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_2"));
    }

    @Test
    public void testMigrationNodeNextItem() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setInternalProcess((Process)new DummyProcess("process_B", "2"));
        processImpl.setProcessId("process_A");
        processImpl.setProcessVersion("1");
        ExtendedNodeInstanceImpl nodeInstanceImpl = new ExtendedNodeInstanceImpl(){};
        nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processImpl);
        nodeInstanceImpl.setNodeId(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_2"));
        service.migrateNodeElement(this.processes, (KogitoNodeInstance)nodeInstanceImpl);
        Assertions.assertThat((Object)nodeInstanceImpl).hasFieldOrPropertyWithValue("nodeId", (Object)WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
    }

    @Test
    public void testMigrationNodeNonExistent() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setProcess((Process)new DummyProcess("process_A", "1"));
        ExtendedNodeInstanceImpl nodeInstanceImpl = new ExtendedNodeInstanceImpl(){};
        nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processImpl);
        nodeInstanceImpl.setNodeId(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
        service.migrateNodeElement(this.processes, (KogitoNodeInstance)nodeInstanceImpl);
        Assertions.assertThat((Object)nodeInstanceImpl).hasFieldOrPropertyWithValue("nodeId", (Object)WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
    }

    @Test
    public void testMigrationNodeNotMigratedWrongProcess() {
        MigrationPlanService service = new MigrationPlanService();
        RuleFlowProcessInstance processImpl = new RuleFlowProcessInstance();
        processImpl.setProcess((Process)new DummyProcess("process_C", "1"));
        ExtendedNodeInstanceImpl nodeInstanceImpl = new ExtendedNodeInstanceImpl(){};
        nodeInstanceImpl.setProcessInstance((WorkflowProcessInstance)processImpl);
        nodeInstanceImpl.setNodeId(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
        service.migrateNodeElement(this.processes, (KogitoNodeInstance)nodeInstanceImpl);
        Assertions.assertThat((Object)nodeInstanceImpl).hasFieldOrPropertyWithValue("nodeId", (Object)WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
    }
}

