/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.flow.migration;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.jbpm.flow.migration.MigrationPlanProvider;
import org.jbpm.flow.migration.model.MigrationPlan;
import org.jbpm.flow.migration.model.NodeInstanceMigrationPlan;
import org.jbpm.flow.migration.model.ProcessDefinitionMigrationPlan;
import org.jbpm.flow.migration.model.ProcessInstanceMigrationPlan;
import org.jbpm.ruleflow.core.WorkflowElementIdentifierFactory;
import org.junit.jupiter.api.Test;

public class MigrationPlanProviderTest {
    @Test
    public void testReadingFiles() {
        MigrationPlanProvider provider = MigrationPlanProvider.newMigrationPlanProviderBuilder().withEnvironmentDefaults().build();
        List plans = provider.findMigrationPlans();
        NodeInstanceMigrationPlan a = new NodeInstanceMigrationPlan(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_1"), WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_2"));
        NodeInstanceMigrationPlan b = new NodeInstanceMigrationPlan(WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_2"), WorkflowElementIdentifierFactory.fromExternalFormat((String)"node_3"));
        ProcessInstanceMigrationPlan pdmp = new ProcessInstanceMigrationPlan();
        pdmp.setSourceProcessDefinition(new ProcessDefinitionMigrationPlan("process_A", "1"));
        pdmp.setTargetProcessDefinition(new ProcessDefinitionMigrationPlan("process_B", "2"));
        pdmp.setNodeInstanceMigrationPlan(Arrays.asList(a, b));
        MigrationPlan plan = new MigrationPlan();
        plan.setName("my simple migration");
        plan.setProcessMigrationPlan(pdmp);
        ((ListAssert)Assertions.assertThat((List)plans).hasSize(2)).contains((Object[])new MigrationPlan[]{plan});
    }
}

