
package org.jbpm.serverless.workflow.api.choices;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Single Choice
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({

})
public class SingleChoice
    extends DefaultChoice
    implements Serializable, Choice
{

    private final static long serialVersionUID = 1466781108675078687L;

    @Override
    public SingleChoice withPath(String path) {
        super.withPath(path);
        return this;
    }

    @Override
    public SingleChoice withValue(String value) {
        super.withValue(value);
        return this;
    }

    @Override
    public SingleChoice withOperator(org.jbpm.serverless.workflow.api.choices.DefaultChoice.Operator operator) {
        super.withOperator(operator);
        return this;
    }

    @Override
    public SingleChoice withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

}
