
package org.jbpm.serverless.workflow.api.produce;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "nameRef",
    "data"
})
public class ProduceEvent implements Serializable
{

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("nameRef")
    @JsonPropertyDescription("References a name of a defined event")
    @Size(min = 1)
    @NotNull
    private String nameRef;
    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("JSONPath expression which selects parts of the states data output to become the data of the produced event")
    private String data;
    private final static long serialVersionUID = -2043386787597332595L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProduceEvent() {
    }

    /**
     * 
     * @param nameRef
     */
    public ProduceEvent(String nameRef) {
        super();
        this.nameRef = nameRef;
    }

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("nameRef")
    public String getNameRef() {
        return nameRef;
    }

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("nameRef")
    public void setNameRef(String nameRef) {
        this.nameRef = nameRef;
    }

    public ProduceEvent withNameRef(String nameRef) {
        this.nameRef = nameRef;
        return this;
    }

    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    public String getData() {
        return data;
    }

    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    public void setData(String data) {
        this.data = data;
    }

    public ProduceEvent withData(String data) {
        this.data = data;
        return this;
    }

}
