/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.RelayState;
import org.jbpm.serverless.workflow.parser.ServerlessWorkflowParser;

public abstract class BaseServerlessTest {
    protected static final Workflow singleRelayStateWorkflow = new Workflow().withStates(Collections.singletonList(new RelayState().withName("relayState").withType(DefaultState.Type.RELAY).withStart(new Start().withKind(Start.Kind.DEFAULT)).withEnd(new End(End.Kind.DEFAULT))));
    protected static final Workflow multiRelayStateWorkflow = new Workflow().withStates(Arrays.asList(new RelayState().withName("relayState").withType(DefaultState.Type.RELAY).withStart(new Start().withKind(Start.Kind.DEFAULT)).withEnd(new End(End.Kind.DEFAULT)), new RelayState().withName("relayState2").withType(DefaultState.Type.RELAY).withEnd(new End(End.Kind.DEFAULT))));
    protected static final Workflow eventDefOnlyWorkflow = new Workflow().withEvents(Collections.singletonList(new EventDefinition().withName("sampleEvent").withSource("sampleSource").withType("sampleType")));

    protected ServerlessWorkflowParser getWorkflowParser(String workflowLocation) {
        ServerlessWorkflowParser parser = workflowLocation.endsWith(".sw.json") ? new ServerlessWorkflowParser("json") : new ServerlessWorkflowParser("yml");
        return parser;
    }

    protected Reader classpathResourceReader(String location) {
        return new InputStreamReader(this.getClass().getResourceAsStream(location));
    }
}

