/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.process.core.Work;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.serverless.workflow.BaseServerlessTest;
import org.jbpm.serverless.workflow.TestNodeContainer;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.functions.Function;
import org.jbpm.serverless.workflow.api.produce.ProduceEvent;
import org.jbpm.serverless.workflow.parser.core.ServerlessWorkflowFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.Test;

public class WorkflowFactoryTest
extends BaseServerlessTest {
    @Test
    public void testCreateProcess() {
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        RuleFlowProcess process = factory.createProcess(singleRelayStateWorkflow);
        Assertions.assertThat((Object)process).isNotNull();
        Assertions.assertThat((String)process.getId()).isEqualTo("serverless");
        Assertions.assertThat((String)process.getName()).isEqualTo("workflow");
        Assertions.assertThat((String)process.getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)process.getPackageName()).isEqualTo("org.kie.kogito.serverless");
        Assertions.assertThat((boolean)process.isAutoComplete()).isTrue();
        Assertions.assertThat((String)process.getVisibility()).isEqualTo("Public");
        Assertions.assertThat((Iterable)process.getImports()).isNotNull();
        Assertions.assertThat((Object)process.getVariableScope()).isNotNull();
        Assertions.assertThat((List)process.getVariableScope().getVariables()).isNotNull();
        Assertions.assertThat((List)process.getVariableScope().getVariables()).hasSize(1);
    }

    @Test
    public void testStartNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        StartNode startNode = factory.startNode(1L, "start", (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)startNode).isNotNull();
        Assertions.assertThat((String)startNode.getName()).isEqualTo("start");
    }

    @Test
    public void testMessageStartNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        EventDefinition eventDefinition = new EventDefinition().withName("testEvent").withSource("testSource").withType("testType");
        StartNode startNode = factory.messageStartNode(1L, eventDefinition, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)startNode).isNotNull();
        Assertions.assertThat((String)startNode.getName()).isEqualTo(eventDefinition.getName());
        Assertions.assertThat((Map)startNode.getMetaData()).isNotNull();
        Assertions.assertThat(startNode.getMetaData().get("TriggerType")).isEqualTo((Object)"ConsumeMessage");
        Assertions.assertThat(startNode.getMetaData().get("TriggerRef")).isEqualTo((Object)eventDefinition.getSource());
        Assertions.assertThat(startNode.getMetaData().get("MessageType")).isEqualTo((Object)"com.fasterxml.jackson.databind.JsonNode");
    }

    @Test
    public void testEndNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        EndNode endNode = factory.endNode(1L, "end", true, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)endNode).isNotNull();
        Assertions.assertThat((String)endNode.getName()).isEqualTo("end");
    }

    @Test
    public void testMessageEndNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        End endDef = new End().withKind(End.Kind.EVENT).withProduceEvent(new ProduceEvent().withNameRef("sampleEvent").withData("sampleData"));
        EndNode endNode = factory.messageEndNode(1L, "End", eventDefOnlyWorkflow, endDef, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)endNode).isNotNull();
        Assertions.assertThat((String)endNode.getName()).isEqualTo("End");
        Assertions.assertThat((Map)endNode.getMetaData()).isNotNull();
        Assertions.assertThat(endNode.getMetaData().get("TriggerRef")).isEqualTo((Object)"sampleSource");
        Assertions.assertThat(endNode.getMetaData().get("TriggerType")).isEqualTo((Object)"ProduceMessage");
        Assertions.assertThat(endNode.getMetaData().get("MessageType")).isEqualTo((Object)"com.fasterxml.jackson.databind.JsonNode");
        Assertions.assertThat(endNode.getMetaData().get("MappingVariable")).isEqualTo((Object)"sampleData");
    }

    @Test
    public void testTimerNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        TimerNode timerNode = factory.timerNode(1L, "timer", "sampleDelay", (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)timerNode).isNotNull();
        Assertions.assertThat((String)timerNode.getName()).isEqualTo("timer");
        Assertions.assertThat(timerNode.getMetaData().get("EventType")).isEqualTo((Object)"timer");
    }

    @Test
    public void testCallActivity() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        SubProcessNode subProcessNode = factory.callActivity(1L, "subprocess", "calledId", true, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)subProcessNode).isNotNull();
        Assertions.assertThat((String)subProcessNode.getName()).isEqualTo("subprocess");
        Assertions.assertThat((String)subProcessNode.getProcessId()).isEqualTo("calledId");
        Assertions.assertThat((Map)subProcessNode.getInMappings()).isNotNull();
        Assertions.assertThat((Map)subProcessNode.getInMappings()).hasSize(1);
        Assertions.assertThat((Map)subProcessNode.getOutMappings()).isNotNull();
        Assertions.assertThat((Map)subProcessNode.getOutMappings()).hasSize(1);
        Assertions.assertThat((Object)subProcessNode.getMetaData("BPMN.InputTypes")).isNotNull();
        Assertions.assertThat((Object)subProcessNode.getMetaData("BPMN.OutputTypes")).isNotNull();
    }

    @Test
    public void testaAdMessageEndNodeAction() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        EndNode endNode = factory.endNode(1L, "end", true, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)endNode).isNotNull();
        Assertions.assertThat((String)endNode.getName()).isEqualTo("end");
        factory.addMessageEndNodeAction(endNode, "testVar", "testMessageType");
        Assertions.assertThat((List)endNode.getActions("onEntry")).hasSize(1);
    }

    @Test
    public void testAddTriggerToStartNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        StartNode startNode = factory.startNode(1L, "start", (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)startNode).isNotNull();
        Assertions.assertThat((String)startNode.getName()).isEqualTo("start");
        factory.addTriggerToStartNode(startNode, "testTriggerType");
        Assertions.assertThat((List)startNode.getTriggers()).hasSize(1);
    }

    @Test
    public void testScriptNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        ActionNode actionNode = factory.scriptNode(1L, "script", "testScript", (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)actionNode).isNotNull();
        Assertions.assertThat((String)actionNode.getName()).isEqualTo("script");
        Assertions.assertThat((Object)actionNode.getAction()).isNotNull();
    }

    @Test
    public void testServiceNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        Function function = new Function().withName("testFunction").withType("testType").withResource("testResource").withMetadata((Map)new HashMap<String, String>(){
            {
                this.put("interface", "testInterface");
                this.put("operation", "testOperation");
                this.put("implementation", "testImplementation");
            }
        });
        WorkItemNode workItemNode = factory.serviceNode(1L, "testService", function, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)workItemNode).isNotNull();
        Assertions.assertThat((String)workItemNode.getName()).isEqualTo("testService");
        Assertions.assertThat(workItemNode.getMetaData().get("Type")).isEqualTo((Object)"Service Task");
        Assertions.assertThat((Object)workItemNode.getWork()).isNotNull();
        Work work = workItemNode.getWork();
        Assertions.assertThat((String)work.getName()).isEqualTo("Service Task");
        Assertions.assertThat((Object)work.getParameter("Interface")).isEqualTo((Object)"testInterface");
        Assertions.assertThat((Object)work.getParameter("Operation")).isEqualTo((Object)"testOperation");
        Assertions.assertThat((Object)work.getParameter("interfaceImplementationRef")).isEqualTo((Object)"testInterface");
        Assertions.assertThat((Object)work.getParameter("operationImplementationRef")).isEqualTo((Object)"testOperation");
        Assertions.assertThat((Object)work.getParameter("ParameterType")).isEqualTo((Object)"com.fasterxml.jackson.databind.JsonNode");
        Assertions.assertThat((Object)work.getParameter("implementation")).isEqualTo((Object)"testImplementation");
        Assertions.assertThat((Map)workItemNode.getInMappings()).isNotNull();
        Assertions.assertThat((Map)workItemNode.getInMappings()).hasSize(1);
        Assertions.assertThat((Map)workItemNode.getOutMappings()).isNotNull();
        Assertions.assertThat((Map)workItemNode.getOutMappings()).hasSize(1);
    }

    @Test
    public void testSubProcessNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        CompositeContextNode compositeContextNode = factory.subProcessNode(1L, "subprocess", (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)compositeContextNode).isNotNull();
        Assertions.assertThat((String)compositeContextNode.getName()).isEqualTo("subprocess");
        Assertions.assertThat((boolean)compositeContextNode.isAutoComplete()).isTrue();
    }

    @Test
    public void testSplitConstraint() {
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        ConstraintImpl constraint = factory.splitConstraint("testName", "testType", "testDialect", "testConstraint", 0, true);
        Assertions.assertThat((Object)constraint).isNotNull();
        Assertions.assertThat((String)constraint.getName()).isEqualTo("testName");
        Assertions.assertThat((String)constraint.getType()).isEqualTo("testType");
        Assertions.assertThat((String)constraint.getDialect()).isEqualTo("testDialect");
        Assertions.assertThat((String)constraint.getConstraint()).isEqualTo("testConstraint");
        Assertions.assertThat((int)constraint.getPriority()).isEqualTo(0);
        Assertions.assertThat((boolean)constraint.isDefault()).isTrue();
    }

    @Test
    public void testSplitNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        Split split = factory.splitNode(1L, "testSplit", 2, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)split).isNotNull();
        Assertions.assertThat((long)split.getId()).isEqualTo(1L);
        Assertions.assertThat((String)split.getName()).isEqualTo("testSplit");
        Assertions.assertThat((int)split.getType()).isEqualTo(2);
        Assertions.assertThat(split.getMetaData().get("UniqueId")).isEqualTo((Object)"1");
    }

    @Test
    public void testJoinNode() {
        TestNodeContainer nodeContainer = new TestNodeContainer();
        ServerlessWorkflowFactory factory = new ServerlessWorkflowFactory();
        Join join = factory.joinNode(1L, "testJoin", 2, (NodeContainer)nodeContainer);
        Assertions.assertThat((Object)join).isNotNull();
        Assertions.assertThat((long)join.getId()).isEqualTo(1L);
        Assertions.assertThat((String)join.getName()).isEqualTo("testJoin");
        Assertions.assertThat((int)join.getType()).isEqualTo(2);
        Assertions.assertThat(join.getMetaData().get("UniqueId")).isEqualTo((Object)"1");
    }
}

