/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.events;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "source", "type", "correlationToken", "metadata"})
public class EventDefinition
implements Serializable {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Event Definition unique name")
    @Size(min=1)
    @NotNull
    private @Size(min=1) @NotNull String name;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="CloudEvent source UUID")
    @NotNull
    private String source;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="CloudEvent type")
    @NotNull
    private String type;
    @JsonProperty(value="correlationToken")
    @JsonPropertyDescription(value="Context attribute name of the CloudEvent which value is to be used for event correlation")
    private String correlationToken;
    @JsonProperty(value="metadata")
    @JsonPropertyDescription(value="Metadata")
    @Valid
    private Map<String, String> metadata;
    private static final long serialVersionUID = 4879490005212697914L;

    public EventDefinition() {
    }

    public EventDefinition(String name, String source, String type) {
        this.name = name;
        this.source = source;
        this.type = type;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    public EventDefinition withName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    public EventDefinition withSource(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    public EventDefinition withType(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="correlationToken")
    public String getCorrelationToken() {
        return this.correlationToken;
    }

    @JsonProperty(value="correlationToken")
    public void setCorrelationToken(String correlationToken) {
        this.correlationToken = correlationToken;
    }

    public EventDefinition withCorrelationToken(String correlationToken) {
        this.correlationToken = correlationToken;
        return this;
    }

    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public EventDefinition withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }
}

