/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.actions.Action;
import org.jbpm.serverless.workflow.api.branches.Branch;
import org.jbpm.serverless.workflow.api.choices.DefaultChoice;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.functions.Function;
import org.jbpm.serverless.workflow.api.interfaces.Choice;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.mapper.BaseObjectMapper;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.DelayState;
import org.jbpm.serverless.workflow.api.states.EventState;
import org.jbpm.serverless.workflow.api.states.OperationState;
import org.jbpm.serverless.workflow.api.states.ParallelState;
import org.jbpm.serverless.workflow.api.states.RelayState;
import org.jbpm.serverless.workflow.api.states.SubflowState;
import org.jbpm.serverless.workflow.api.states.SwitchState;
import org.jbpm.serverless.workflow.api.transitions.Transition;
import org.jbpm.serverless.workflow.parser.core.ServerlessWorkflowFactory;
import org.jbpm.serverless.workflow.parser.util.ServerlessWorkflowUtils;
import org.jbpm.workflow.core.Constraint;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.ConnectionRef;
import org.jbpm.workflow.core.impl.ConstraintImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.Join;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.kie.api.definition.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerlessWorkflowParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerlessWorkflowParser.class);
    private static final String SCRIPT_TYPE = "script";
    private static final String SCRIPT_TYPE_PARAM = "script";
    private static final String SYSOUT_TYPE = "sysout";
    private static final String SYSOUT_TYPE_PARAM = "message";
    private static final String SERVICE_TYPE = "service";
    private static final String NODE_START_NAME = "Start";
    private static final String NODE_END_NAME = "End";
    private static final String NODETOID_START = "start";
    private static final String NODETOID_END = "end";
    private AtomicLong idCounter = new AtomicLong(1L);
    private ServerlessWorkflowFactory factory;
    private BaseObjectMapper objectMapper;

    public ServerlessWorkflowParser() {
        this.factory = new ServerlessWorkflowFactory();
    }

    public ServerlessWorkflowParser(String workflowFormat) {
        this.objectMapper = ServerlessWorkflowUtils.getObjectMapper(workflowFormat);
        this.factory = new ServerlessWorkflowFactory();
    }

    public Process parseWorkFlow(Reader workflowFile) throws JsonProcessingException {
        StartNode workflowStartNode;
        Workflow workflow = (Workflow)this.objectMapper.readValue(ServerlessWorkflowUtils.readWorkflowFile(workflowFile), Workflow.class);
        RuleFlowProcess process = this.factory.createProcess(workflow);
        HashMap nameToNodeId = new HashMap();
        if (!ServerlessWorkflowUtils.includesSupportedStates(workflow)) {
            LOGGER.warn("workflow includes currently unsupported states.");
            LOGGER.warn("default process is generated.");
            StartNode startNode = this.factory.startNode(this.idCounter.getAndIncrement(), NODE_START_NAME, (NodeContainer)process);
            EndNode endNode = this.factory.endNode(this.idCounter.getAndIncrement(), NODE_END_NAME, true, (NodeContainer)process);
            this.factory.connect(startNode.getId(), endNode.getId(), startNode.getId() + "_" + endNode.getId(), (NodeContainer)process);
            this.factory.validate(process);
            return process;
        }
        List<State> workflowStates = workflow.getStates();
        List<Function> workflowFunctions = workflow.getFunctions();
        HashMap<String, EndNode> workflowEndNodes = new HashMap<String, EndNode>();
        State workflowStartState = ServerlessWorkflowUtils.getWorkflowStartState(workflow);
        if (workflowStartState.getType().equals((Object)DefaultState.Type.EVENT)) {
            EventState startEventState = (EventState)workflowStartState;
            workflowStartNode = this.factory.messageStartNode(this.idCounter.getAndIncrement(), ServerlessWorkflowUtils.getWorkflowEventFor(workflow, startEventState.getEventsActions().get(0).getEventRefs().get(0)), (NodeContainer)process);
        } else {
            workflowStartNode = this.factory.startNode(this.idCounter.getAndIncrement(), NODE_START_NAME, (NodeContainer)process);
        }
        List<State> endStates = ServerlessWorkflowUtils.getWorkflowEndStates(workflow);
        for (State endState : endStates) {
            if (endState.getEnd().getKind() == End.Kind.EVENT) {
                workflowEndNodes.put(endState.getName(), this.factory.messageEndNode(this.idCounter.getAndIncrement(), NODE_END_NAME, workflow, endState.getEnd(), (NodeContainer)process));
                continue;
            }
            workflowEndNodes.put(endState.getName(), this.factory.endNode(this.idCounter.getAndIncrement(), NODE_END_NAME, true, (NodeContainer)process));
        }
        for (State state2 : workflowStates) {
            HashMap<String, Long> startEndMap;
            HashMap<String, Long> startEndMap2;
            CompositeContextNode embeddedSubProcess;
            if (state2.getType().equals((Object)DefaultState.Type.EVENT)) {
                EventState eventState = (EventState)state2;
                if (eventState.getStart() == null) {
                    throw new IllegalArgumentException("currently support only event start states");
                }
                embeddedSubProcess = this.factory.subProcessNode(this.idCounter.getAndIncrement(), state2.getName(), (NodeContainer)process);
                this.handleActions(workflowFunctions, eventState.getEventsActions().get(0).getActions(), embeddedSubProcess);
                this.factory.connect(workflowStartNode.getId(), embeddedSubProcess.getId(), workflowStartNode.getId() + "_" + embeddedSubProcess.getId(), (NodeContainer)process);
                if (state2.getEnd() != null) {
                    this.factory.connect(embeddedSubProcess.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), embeddedSubProcess.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
                }
                startEndMap2 = new HashMap();
                startEndMap2.put(NODETOID_START, embeddedSubProcess.getId());
                startEndMap2.put(NODETOID_END, embeddedSubProcess.getId());
                nameToNodeId.put(state2.getName(), startEndMap2);
            }
            if (state2.getType().equals((Object)DefaultState.Type.OPERATION)) {
                OperationState operationState = (OperationState)state2;
                embeddedSubProcess = this.factory.subProcessNode(this.idCounter.getAndIncrement(), state2.getName(), (NodeContainer)process);
                this.handleActions(workflowFunctions, operationState.getActions(), embeddedSubProcess);
                if (state2.getStart() != null) {
                    this.factory.connect(workflowStartNode.getId(), embeddedSubProcess.getId(), workflowStartNode.getId() + "_" + embeddedSubProcess.getId(), (NodeContainer)process);
                }
                if (state2.getEnd() != null) {
                    this.factory.connect(embeddedSubProcess.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), embeddedSubProcess.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
                }
                startEndMap2 = new HashMap<String, Long>();
                startEndMap2.put(NODETOID_START, embeddedSubProcess.getId());
                startEndMap2.put(NODETOID_END, embeddedSubProcess.getId());
                nameToNodeId.put(state2.getName(), startEndMap2);
            }
            if (state2.getType().equals((Object)DefaultState.Type.DELAY)) {
                DelayState delayState = (DelayState)state2;
                TimerNode timerNode = this.factory.timerNode(this.idCounter.getAndIncrement(), delayState.getName(), delayState.getTimeDelay(), (NodeContainer)process);
                if (state2.getStart() != null) {
                    this.factory.connect(workflowStartNode.getId(), timerNode.getId(), workflowStartNode.getId() + "_" + timerNode.getId(), (NodeContainer)process);
                }
                if (state2.getEnd() != null) {
                    this.factory.connect(timerNode.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), timerNode.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
                }
                startEndMap2 = new HashMap();
                startEndMap2.put(NODETOID_START, timerNode.getId());
                startEndMap2.put(NODETOID_END, timerNode.getId());
                nameToNodeId.put(state2.getName(), startEndMap2);
            }
            if (state2.getType().equals((Object)DefaultState.Type.RELAY)) {
                RelayState relayState = (RelayState)state2;
                JsonNode toInjectNode = relayState.getInject();
                ActionNode actionNode = toInjectNode != null ? this.factory.scriptNode(this.idCounter.getAndIncrement(), relayState.getName(), ServerlessWorkflowUtils.getInjectScript(toInjectNode), (NodeContainer)process) : this.factory.scriptNode(this.idCounter.getAndIncrement(), relayState.getName(), "", (NodeContainer)process);
                if (state2.getStart() != null) {
                    this.factory.connect(workflowStartNode.getId(), actionNode.getId(), workflowStartNode.getId() + "_" + actionNode.getId(), (NodeContainer)process);
                }
                if (state2.getEnd() != null) {
                    this.factory.connect(actionNode.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), actionNode.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
                }
                startEndMap = new HashMap<String, Long>();
                startEndMap.put(NODETOID_START, actionNode.getId());
                startEndMap.put(NODETOID_END, actionNode.getId());
                nameToNodeId.put(state2.getName(), startEndMap);
            }
            if (state2.getType().equals((Object)DefaultState.Type.SUBFLOW)) {
                SubflowState subflowState = (SubflowState)state2;
                SubProcessNode callActivityNode = this.factory.callActivity(this.idCounter.getAndIncrement(), subflowState.getName(), subflowState.getWorkflowId(), subflowState.isWaitForCompletion(), (NodeContainer)process);
                if (state2.getStart() != null) {
                    this.factory.connect(workflowStartNode.getId(), callActivityNode.getId(), workflowStartNode.getId() + "_" + callActivityNode.getId(), (NodeContainer)process);
                }
                if (state2.getEnd() != null) {
                    this.factory.connect(callActivityNode.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), callActivityNode.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
                }
                startEndMap2 = new HashMap();
                startEndMap2.put(NODETOID_START, callActivityNode.getId());
                startEndMap2.put(NODETOID_END, callActivityNode.getId());
                nameToNodeId.put(state2.getName(), startEndMap2);
            }
            if (state2.getType().equals((Object)DefaultState.Type.SWITCH)) {
                SwitchState switchState = (SwitchState)state2;
                Split splitNode = this.factory.splitNode(this.idCounter.getAndIncrement(), switchState.getName(), 2, (NodeContainer)process);
                if (state2.getStart() != null) {
                    this.factory.connect(workflowStartNode.getId(), splitNode.getId(), workflowStartNode.getId() + "_" + splitNode.getId(), (NodeContainer)process);
                }
                startEndMap2 = new HashMap();
                startEndMap2.put(NODETOID_START, splitNode.getId());
                startEndMap2.put(NODETOID_END, splitNode.getId());
                nameToNodeId.put(state2.getName(), startEndMap2);
            }
            if (!state2.getType().equals((Object)DefaultState.Type.PARALLEL)) continue;
            ParallelState parallelState = (ParallelState)state2;
            Split parallelSplit = this.factory.splitNode(this.idCounter.getAndIncrement(), parallelState.getName() + NODE_START_NAME, 1, (NodeContainer)process);
            Join parallelJoin = this.factory.joinNode(this.idCounter.getAndIncrement(), parallelState.getName() + NODE_END_NAME, 1, (NodeContainer)process);
            for (Branch branch : parallelState.getBranches()) {
                SubflowState subflowState = (SubflowState)branch.getStates().get(0);
                SubProcessNode callActivityNode = this.factory.callActivity(this.idCounter.getAndIncrement(), subflowState.getName(), subflowState.getWorkflowId(), subflowState.isWaitForCompletion(), (NodeContainer)process);
                this.factory.connect(parallelSplit.getId(), callActivityNode.getId(), parallelSplit.getId() + "_" + callActivityNode.getId(), (NodeContainer)process);
                this.factory.connect(callActivityNode.getId(), parallelJoin.getId(), callActivityNode.getId() + "_" + parallelJoin.getId(), (NodeContainer)process);
            }
            if (state2.getStart() != null) {
                this.factory.connect(workflowStartNode.getId(), parallelSplit.getId(), workflowStartNode.getId() + "_" + parallelSplit.getId(), (NodeContainer)process);
            }
            if (state2.getEnd() != null) {
                this.factory.connect(parallelJoin.getId(), ((EndNode)workflowEndNodes.get(state2.getName())).getId(), parallelJoin.getId() + "_" + ((EndNode)workflowEndNodes.get(state2.getName())).getId(), (NodeContainer)process);
            }
            startEndMap = new HashMap<String, Long>();
            startEndMap.put(NODETOID_START, parallelSplit.getId());
            startEndMap.put(NODETOID_END, parallelJoin.getId());
            nameToNodeId.put(state2.getName(), startEndMap);
        }
        workflow.getStates().stream().filter(state -> state instanceof State).forEach(state -> {
            Transition transition = state.getTransition();
            if (transition != null && transition.getNextState() != null) {
                Long sourceId = (Long)((Map)nameToNodeId.get(state.getName())).get(NODETOID_END);
                Long targetId = (Long)((Map)nameToNodeId.get(state.getTransition().getNextState())).get(NODETOID_START);
                this.factory.connect(sourceId, targetId, sourceId + "_" + targetId, (NodeContainer)process);
            }
        });
        List<State> switchStates = ServerlessWorkflowUtils.getStatesByType(workflow, DefaultState.Type.SWITCH);
        if (switchStates != null && switchStates.size() > 0) {
            for (State state3 : switchStates) {
                SwitchState switchState = (SwitchState)state3;
                long splitNodeId = (Long)((Map)nameToNodeId.get(switchState.getName())).get(NODETOID_START);
                Split xorSplit = (Split)process.getNode(splitNodeId);
                if (xorSplit != null) {
                    List<Choice> choices;
                    if (switchState.getDefault() != null && switchState.getDefault().getNextState() != null) {
                        long targetId = (Long)((Map)nameToNodeId.get(switchState.getDefault().getNextState())).get(NODETOID_START);
                        xorSplit.getMetaData().put("Default", xorSplit.getId() + "_" + targetId);
                    }
                    if ((choices = switchState.getChoices()) != null && choices.size() > 0) {
                        for (Choice choice : choices) {
                            if (choice instanceof DefaultChoice) {
                                DefaultChoice defaultChoice = (DefaultChoice)choice;
                                long targetId = (Long)((Map)nameToNodeId.get(defaultChoice.getTransition().getNextState())).get(NODETOID_START);
                                this.factory.connect(xorSplit.getId(), targetId, xorSplit.getId() + "_" + targetId, (NodeContainer)process);
                                boolean isDefaultConstraint = false;
                                if (switchState.getDefault().getNextState() != null && defaultChoice.getTransition().getNextState().equals(switchState.getDefault().getNextState())) {
                                    isDefaultConstraint = true;
                                }
                                ConstraintImpl constraintImpl = this.factory.splitConstraint(xorSplit.getId() + "_" + targetId, "DROOLS_DEFAULT", "java", ServerlessWorkflowUtils.conditionScript(defaultChoice.getPath(), defaultChoice.getOperator(), defaultChoice.getValue()), 0, isDefaultConstraint);
                                xorSplit.addConstraint(new ConnectionRef(xorSplit.getId() + "_" + targetId, targetId, "DROOLS_DEFAULT"), (Constraint)constraintImpl);
                                continue;
                            }
                            LOGGER.warn("currently support default(single) choices only");
                        }
                        continue;
                    }
                    LOGGER.warn("switch state has no choices: {}", (Object)switchState.getName());
                    continue;
                }
                LOGGER.warn("unable to get split node for switch state: {}", (Object)switchState.getName());
            }
        }
        this.factory.validate(process);
        return process;
    }

    protected void handleActions(List<Function> workflowFunctions, List<Action> actions, CompositeContextNode embeddedSubProcess) {
        if (actions != null && !actions.isEmpty()) {
            StartNode embeddedStartNode;
            StartNode start = embeddedStartNode = this.factory.startNode(this.idCounter.getAndIncrement(), "EmbeddedStart", (NodeContainer)embeddedSubProcess);
            ActionNode current = null;
            for (Action action : actions) {
                String script;
                Function actionFunction = workflowFunctions.stream().filter(wf -> wf.getName().equals(action.getFunctionRef().getRefName())).findFirst().get();
                if (actionFunction.getType() != null) {
                    if ("script".equalsIgnoreCase(actionFunction.getType())) {
                        script = ServerlessWorkflowUtils.scriptFunctionScript(action.getFunctionRef().getParameters().get("script"));
                        current = this.factory.scriptNode(this.idCounter.getAndIncrement(), action.getFunctionRef().getRefName(), script, (NodeContainer)embeddedSubProcess);
                        this.factory.connect(start.getId(), current.getId(), start.getId() + "_" + current.getId(), (NodeContainer)embeddedSubProcess);
                        start = current;
                        continue;
                    }
                    if (SYSOUT_TYPE.equalsIgnoreCase(actionFunction.getType())) {
                        script = ServerlessWorkflowUtils.sysOutFunctionScript(action.getFunctionRef().getParameters().get(SYSOUT_TYPE_PARAM));
                        current = this.factory.scriptNode(this.idCounter.getAndIncrement(), action.getFunctionRef().getRefName(), script, (NodeContainer)embeddedSubProcess);
                        this.factory.connect(start.getId(), current.getId(), start.getId() + "_" + current.getId(), (NodeContainer)embeddedSubProcess);
                        start = current;
                        continue;
                    }
                    if (SERVICE_TYPE.equalsIgnoreCase(actionFunction.getType())) {
                        current = this.factory.serviceNode(this.idCounter.getAndIncrement(), action.getFunctionRef().getRefName(), actionFunction, (NodeContainer)embeddedSubProcess);
                        this.factory.connect(start.getId(), current.getId(), start.getId() + "_" + current.getId(), (NodeContainer)embeddedSubProcess);
                        start = current;
                        continue;
                    }
                    LOGGER.warn("currently unsupported function type, supported types are 'script', 'sysout', 'service'");
                    LOGGER.warn("defaulting to script type");
                    script = ServerlessWorkflowUtils.scriptFunctionScript("");
                    current = this.factory.scriptNode(this.idCounter.getAndIncrement(), action.getFunctionRef().getRefName(), script, (NodeContainer)embeddedSubProcess);
                    this.factory.connect(start.getId(), current.getId(), start.getId() + "_" + current.getId(), (NodeContainer)embeddedSubProcess);
                    start = current;
                    continue;
                }
                LOGGER.warn("invalid function type. supported types are 'script', 'sysout', 'service'");
                LOGGER.warn("defaulting to script type");
                script = ServerlessWorkflowUtils.scriptFunctionScript("");
                current = this.factory.scriptNode(this.idCounter.getAndIncrement(), action.getFunctionRef().getRefName(), script, (NodeContainer)embeddedSubProcess);
                this.factory.connect(start.getId(), current.getId(), start.getId() + "_" + current.getId(), (NodeContainer)embeddedSubProcess);
                start = current;
            }
            EndNode embeddedEndNode = this.factory.endNode(this.idCounter.getAndIncrement(), "EmbeddedEnd", true, (NodeContainer)embeddedSubProcess);
            try {
                this.factory.connect(current.getId(), embeddedEndNode.getId(), current.getId() + "_" + embeddedEndNode.getId(), (NodeContainer)embeddedSubProcess);
            }
            catch (NullPointerException e) {
                LOGGER.warn("unable to connect current node to embedded end node");
            }
        }
    }
}

