/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.jbpm.serverless.workflow.api.Workflow;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.jbpm.serverless.workflow.api.states.InjectState;
import org.jbpm.serverless.workflow.parser.ServerlessWorkflowParser;
import org.jbpm.serverless.workflow.parser.core.ServerlessWorkflowFactory;
import org.jbpm.serverless.workflow.parser.util.WorkflowAppContext;

public abstract class BaseServerlessTest {
    protected static ServerlessWorkflowFactory testFactory = new ServerlessWorkflowFactory(WorkflowAppContext.ofProperties((Properties)BaseServerlessTest.testWorkflowProperties()));
    protected static final Workflow singleInjectStateWorkflow = new Workflow().withStates(Collections.singletonList(new InjectState().withName("relayState").withType(DefaultState.Type.INJECT).withStart(new Start().withKind(Start.Kind.DEFAULT)).withEnd(new End(End.Kind.DEFAULT))));
    protected static final Workflow multiInjectStateWorkflow = new Workflow().withStates(Arrays.asList(new InjectState().withName("relayState").withType(DefaultState.Type.INJECT).withStart(new Start().withKind(Start.Kind.DEFAULT)).withEnd(new End(End.Kind.DEFAULT)), new InjectState().withName("relayState2").withType(DefaultState.Type.INJECT).withEnd(new End(End.Kind.DEFAULT))));
    protected static final Workflow eventDefOnlyWorkflow = new Workflow().withEvents(Collections.singletonList(new EventDefinition().withName("sampleEvent").withSource("sampleSource").withType("sampleType")));

    protected ServerlessWorkflowParser getWorkflowParser(String workflowLocation) {
        ServerlessWorkflowParser parser = workflowLocation.endsWith(".sw.json") ? new ServerlessWorkflowParser("json") : new ServerlessWorkflowParser("yml");
        return parser;
    }

    protected Reader classpathResourceReader(String location) {
        return new InputStreamReader(this.getClass().getResourceAsStream(location));
    }

    protected static Properties testWorkflowProperties() {
        Properties properties = new Properties();
        properties.put("kogito.sw.functions.testfunction1.testprop1", "testprop1val");
        properties.put("kogito.sw.functions.testfunction1.testprop2", "testprop2val");
        properties.put("kogito.sw.functions.testfunction2.testprop1", "testprop1val");
        properties.put("kogito.sw.functions.testfunction2.testprop2", "testprop2val");
        properties.put("kogito.sw.functions.testfunction3.ruleflowgroup", "testruleflowgroup");
        return properties;
    }
}

