
package org.jbpm.serverless.workflow.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.events.EventDefinition;
import org.jbpm.serverless.workflow.api.functions.Function;
import org.jbpm.serverless.workflow.api.interfaces.Extension;
import org.jbpm.serverless.workflow.api.interfaces.State;


/**
 * Serverless Workflow is a vendor-neutral specification for defining the model of workflows responsible for orchestrating event-driven serverless applications.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "id",
    "name",
    "description",
    "version",
    "schemaVersion",
    "dataInputSchema",
    "dataOutputSchema",
    "metadata",
    "expressionLanguage",
    "events",
    "functions",
    "states",
    "extensions"
})
public class Workflow implements Serializable
{

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    @JsonPropertyDescription("Workflow unique identifier")
    @Size(min = 1)
    @NotNull
    private java.lang.String id;
    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Workflow name")
    @Size(min = 1)
    @NotNull
    private java.lang.String name;
    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    @JsonPropertyDescription("Workflow description")
    private java.lang.String description;
    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    @JsonPropertyDescription("Workflow version")
    @NotNull
    private java.lang.String version;
    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    @JsonPropertyDescription("Serverless Workflow schema version")
    private java.lang.String schemaVersion;
    /**
     * URI to JSON Schema that workflow data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    @JsonPropertyDescription("URI to JSON Schema that workflow data input adheres to")
    private java.lang.String dataInputSchema;
    /**
     * URI to JSON Schema that workflow data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    @JsonPropertyDescription("URI to JSON Schema that workflow data output adheres to")
    private java.lang.String dataOutputSchema;
    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    @JsonPropertyDescription("Metadata")
    @Valid
    private Map<String, String> metadata;
    /**
     * Default expression language to be used throughout the workflow definition
     * 
     */
    @JsonProperty("expressionLanguage")
    @JsonPropertyDescription("Default expression language to be used throughout the workflow definition")
    private java.lang.String expressionLanguage;
    /**
     * Workflow event definitions. Defines events that can be consumed or produced
     * 
     */
    @JsonProperty("events")
    @JsonPropertyDescription("Workflow event definitions. Defines events that can be consumed or produced")
    @Valid
    private List<EventDefinition> events = new ArrayList<EventDefinition>();
    /**
     * Workflow functions
     * 
     */
    @JsonProperty("functions")
    @JsonPropertyDescription("Workflow functions")
    @Valid
    private List<Function> functions = new ArrayList<Function>();
    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    @JsonPropertyDescription("State Definitions")
    @Valid
    @NotNull
    private List<State> states = new ArrayList<State>();
    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    @JsonPropertyDescription("Workflow Extensions")
    @Valid
    private List<Extension> extensions = new ArrayList<Extension>();
    private final static long serialVersionUID = 5840537458473371082L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Workflow() {
    }

    /**
     * 
     * @param name
     * @param id
     * @param version
     * @param states
     */
    public Workflow(java.lang.String id, java.lang.String name, java.lang.String version, List<State> states) {
        super();
        this.id = id;
        this.name = name;
        this.version = version;
        this.states = states;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public java.lang.String getId() {
        return id;
    }

    /**
     * Workflow unique identifier
     * (Required)
     * 
     */
    @JsonProperty("id")
    public void setId(java.lang.String id) {
        this.id = id;
    }

    public Workflow withId(java.lang.String id) {
        this.id = id;
        return this;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public java.lang.String getName() {
        return name;
    }

    /**
     * Workflow name
     * (Required)
     * 
     */
    @JsonProperty("name")
    public void setName(java.lang.String name) {
        this.name = name;
    }

    public Workflow withName(java.lang.String name) {
        this.name = name;
        return this;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public java.lang.String getDescription() {
        return description;
    }

    /**
     * Workflow description
     * 
     */
    @JsonProperty("description")
    public void setDescription(java.lang.String description) {
        this.description = description;
    }

    public Workflow withDescription(java.lang.String description) {
        this.description = description;
        return this;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public java.lang.String getVersion() {
        return version;
    }

    /**
     * Workflow version
     * (Required)
     * 
     */
    @JsonProperty("version")
    public void setVersion(java.lang.String version) {
        this.version = version;
    }

    public Workflow withVersion(java.lang.String version) {
        this.version = version;
        return this;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    public java.lang.String getSchemaVersion() {
        return schemaVersion;
    }

    /**
     * Serverless Workflow schema version
     * 
     */
    @JsonProperty("schemaVersion")
    public void setSchemaVersion(java.lang.String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public Workflow withSchemaVersion(java.lang.String schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    /**
     * URI to JSON Schema that workflow data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    public java.lang.String getDataInputSchema() {
        return dataInputSchema;
    }

    /**
     * URI to JSON Schema that workflow data input adheres to
     * 
     */
    @JsonProperty("dataInputSchema")
    public void setDataInputSchema(java.lang.String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
    }

    public Workflow withDataInputSchema(java.lang.String dataInputSchema) {
        this.dataInputSchema = dataInputSchema;
        return this;
    }

    /**
     * URI to JSON Schema that workflow data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    public java.lang.String getDataOutputSchema() {
        return dataOutputSchema;
    }

    /**
     * URI to JSON Schema that workflow data output adheres to
     * 
     */
    @JsonProperty("dataOutputSchema")
    public void setDataOutputSchema(java.lang.String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
    }

    public Workflow withDataOutputSchema(java.lang.String dataOutputSchema) {
        this.dataOutputSchema = dataOutputSchema;
        return this;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public Map<String, String> getMetadata() {
        return metadata;
    }

    /**
     * Metadata
     * 
     */
    @JsonProperty("metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Workflow withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Default expression language to be used throughout the workflow definition
     * 
     */
    @JsonProperty("expressionLanguage")
    public java.lang.String getExpressionLanguage() {
        return expressionLanguage;
    }

    /**
     * Default expression language to be used throughout the workflow definition
     * 
     */
    @JsonProperty("expressionLanguage")
    public void setExpressionLanguage(java.lang.String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public Workflow withExpressionLanguage(java.lang.String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
        return this;
    }

    /**
     * Workflow event definitions. Defines events that can be consumed or produced
     * 
     */
    @JsonProperty("events")
    public List<EventDefinition> getEvents() {
        return events;
    }

    /**
     * Workflow event definitions. Defines events that can be consumed or produced
     * 
     */
    @JsonProperty("events")
    public void setEvents(List<EventDefinition> events) {
        this.events = events;
    }

    public Workflow withEvents(List<EventDefinition> events) {
        this.events = events;
        return this;
    }

    /**
     * Workflow functions
     * 
     */
    @JsonProperty("functions")
    public List<Function> getFunctions() {
        return functions;
    }

    /**
     * Workflow functions
     * 
     */
    @JsonProperty("functions")
    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public Workflow withFunctions(List<Function> functions) {
        this.functions = functions;
        return this;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public List<State> getStates() {
        return states;
    }

    /**
     * State Definitions
     * (Required)
     * 
     */
    @JsonProperty("states")
    public void setStates(List<State> states) {
        this.states = states;
    }

    public Workflow withStates(List<State> states) {
        this.states = states;
        return this;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public List<Extension> getExtensions() {
        return extensions;
    }

    /**
     * Workflow Extensions
     * 
     */
    @JsonProperty("extensions")
    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public Workflow withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

}
