
package org.jbpm.serverless.workflow.api.filters;

import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "dataInputPath",
    "dataResultsPath"
})
public class ActionDataFilter implements Serializable
{

    /**
     * JSONPath definition that selects parts of the states data input to be the action data
     * 
     */
    @JsonProperty("dataInputPath")
    @JsonPropertyDescription("JSONPath definition that selects parts of the states data input to be the action data")
    private String dataInputPath;
    /**
     * JSONPath definition that selects parts of the actions data result, to be merged with the states data
     * 
     */
    @JsonProperty("dataResultsPath")
    @JsonPropertyDescription("JSONPath definition that selects parts of the actions data result, to be merged with the states data")
    private String dataResultsPath;
    private final static long serialVersionUID = 7520689790288922693L;

    /**
     * JSONPath definition that selects parts of the states data input to be the action data
     * 
     */
    @JsonProperty("dataInputPath")
    public String getDataInputPath() {
        return dataInputPath;
    }

    /**
     * JSONPath definition that selects parts of the states data input to be the action data
     * 
     */
    @JsonProperty("dataInputPath")
    public void setDataInputPath(String dataInputPath) {
        this.dataInputPath = dataInputPath;
    }

    public ActionDataFilter withDataInputPath(String dataInputPath) {
        this.dataInputPath = dataInputPath;
        return this;
    }

    /**
     * JSONPath definition that selects parts of the actions data result, to be merged with the states data
     * 
     */
    @JsonProperty("dataResultsPath")
    public String getDataResultsPath() {
        return dataResultsPath;
    }

    /**
     * JSONPath definition that selects parts of the actions data result, to be merged with the states data
     * 
     */
    @JsonProperty("dataResultsPath")
    public void setDataResultsPath(String dataResultsPath) {
        this.dataResultsPath = dataResultsPath;
    }

    public ActionDataFilter withDataResultsPath(String dataResultsPath) {
        this.dataResultsPath = dataResultsPath;
        return this;
    }

}
