
package org.jbpm.serverless.workflow.api.produce;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventRef",
    "data"
})
public class ProduceEvent implements Serializable
{

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    @JsonPropertyDescription("References a name of a defined event")
    @Size(min = 1)
    @NotNull
    private String eventRef;
    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    @JsonPropertyDescription("JSONPath expression which selects parts of the states data output to become the data of the produced event")
    private String data;
    private final static long serialVersionUID = -1643045801711748391L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ProduceEvent() {
    }

    /**
     * 
     * @param eventRef
     */
    public ProduceEvent(String eventRef) {
        super();
        this.eventRef = eventRef;
    }

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    public String getEventRef() {
        return eventRef;
    }

    /**
     * References a name of a defined event
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    public void setEventRef(String eventRef) {
        this.eventRef = eventRef;
    }

    public ProduceEvent withEventRef(String eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    public String getData() {
        return data;
    }

    /**
     * JSONPath expression which selects parts of the states data output to become the data of the produced event
     * 
     */
    @JsonProperty("data")
    public void setData(String data) {
        this.data = data;
    }

    public ProduceEvent withData(String data) {
        this.data = data;
        return this;
    }

}
