
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Execute a set of defined states for each element of the data input array
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "inputCollection",
    "outputCollection",
    "inputParameter",
    "max",
    "timeDelay",
    "states"
})
public class ForEachState
    extends DefaultState
    implements Serializable, org.jbpm.serverless.workflow.api.interfaces.State
{

    /**
     * JSONPath expression selecting an JSON array element of the states data input
     * (Required)
     * 
     */
    @JsonProperty("inputCollection")
    @JsonPropertyDescription("JSONPath expression selecting an JSON array element of the states data input")
    @NotNull
    private java.lang.String inputCollection;
    /**
     * JSONPath expression specifying where in the states data output to place the final data output of each iteration of the executed states
     * 
     */
    @JsonProperty("outputCollection")
    @JsonPropertyDescription("JSONPath expression specifying where in the states data output to place the final data output of each iteration of the executed states")
    private java.lang.String outputCollection;
    /**
     * JSONPath expression specifying an JSON object field of the states data input. For each parallel iteration, this field will get populated with a unique element of the inputCollection array
     * (Required)
     * 
     */
    @JsonProperty("inputParameter")
    @JsonPropertyDescription("JSONPath expression specifying an JSON object field of the states data input. For each parallel iteration, this field will get populated with a unique element of the inputCollection array")
    @NotNull
    private java.lang.String inputParameter;
    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    @JsonPropertyDescription("Specifies how upper bound on how many iterations may run in parallel")
    @DecimalMin("0")
    private int max = 0;
    /**
     * Amount of time (ISO 8601 format) to wait between each iteration 
     * 
     */
    @JsonProperty("timeDelay")
    @JsonPropertyDescription("Amount of time (ISO 8601 format) to wait between each iteration ")
    private java.lang.String timeDelay;
    /**
     * States to be executed for each of the elements of inputCollection
     * (Required)
     * 
     */
    @JsonProperty("states")
    @JsonPropertyDescription("States to be executed for each of the elements of inputCollection")
    @Valid
    @NotNull
    private List<org.jbpm.serverless.workflow.api.interfaces.State> states = new ArrayList<org.jbpm.serverless.workflow.api.interfaces.State>();
    private final static long serialVersionUID = -6062804359170416984L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public ForEachState() {
    }

    /**
     * 
     * @param inputParameter
     * @param name
     * @param type
     * @param inputCollection
     * @param states
     */
    public ForEachState(java.lang.String inputCollection, java.lang.String inputParameter, List<org.jbpm.serverless.workflow.api.interfaces.State> states, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.inputCollection = inputCollection;
        this.inputParameter = inputParameter;
        this.states = states;
    }

    /**
     * JSONPath expression selecting an JSON array element of the states data input
     * (Required)
     * 
     */
    @JsonProperty("inputCollection")
    public java.lang.String getInputCollection() {
        return inputCollection;
    }

    /**
     * JSONPath expression selecting an JSON array element of the states data input
     * (Required)
     * 
     */
    @JsonProperty("inputCollection")
    public void setInputCollection(java.lang.String inputCollection) {
        this.inputCollection = inputCollection;
    }

    public ForEachState withInputCollection(java.lang.String inputCollection) {
        this.inputCollection = inputCollection;
        return this;
    }

    /**
     * JSONPath expression specifying where in the states data output to place the final data output of each iteration of the executed states
     * 
     */
    @JsonProperty("outputCollection")
    public java.lang.String getOutputCollection() {
        return outputCollection;
    }

    /**
     * JSONPath expression specifying where in the states data output to place the final data output of each iteration of the executed states
     * 
     */
    @JsonProperty("outputCollection")
    public void setOutputCollection(java.lang.String outputCollection) {
        this.outputCollection = outputCollection;
    }

    public ForEachState withOutputCollection(java.lang.String outputCollection) {
        this.outputCollection = outputCollection;
        return this;
    }

    /**
     * JSONPath expression specifying an JSON object field of the states data input. For each parallel iteration, this field will get populated with a unique element of the inputCollection array
     * (Required)
     * 
     */
    @JsonProperty("inputParameter")
    public java.lang.String getInputParameter() {
        return inputParameter;
    }

    /**
     * JSONPath expression specifying an JSON object field of the states data input. For each parallel iteration, this field will get populated with a unique element of the inputCollection array
     * (Required)
     * 
     */
    @JsonProperty("inputParameter")
    public void setInputParameter(java.lang.String inputParameter) {
        this.inputParameter = inputParameter;
    }

    public ForEachState withInputParameter(java.lang.String inputParameter) {
        this.inputParameter = inputParameter;
        return this;
    }

    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    public int getMax() {
        return max;
    }

    /**
     * Specifies how upper bound on how many iterations may run in parallel
     * 
     */
    @JsonProperty("max")
    public void setMax(int max) {
        this.max = max;
    }

    public ForEachState withMax(int max) {
        this.max = max;
        return this;
    }

    /**
     * Amount of time (ISO 8601 format) to wait between each iteration 
     * 
     */
    @JsonProperty("timeDelay")
    public java.lang.String getTimeDelay() {
        return timeDelay;
    }

    /**
     * Amount of time (ISO 8601 format) to wait between each iteration 
     * 
     */
    @JsonProperty("timeDelay")
    public void setTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
    }

    public ForEachState withTimeDelay(java.lang.String timeDelay) {
        this.timeDelay = timeDelay;
        return this;
    }

    /**
     * States to be executed for each of the elements of inputCollection
     * (Required)
     * 
     */
    @JsonProperty("states")
    public List<org.jbpm.serverless.workflow.api.interfaces.State> getStates() {
        return states;
    }

    /**
     * States to be executed for each of the elements of inputCollection
     * (Required)
     * 
     */
    @JsonProperty("states")
    public void setStates(List<org.jbpm.serverless.workflow.api.interfaces.State> states) {
        this.states = states;
    }

    public ForEachState withStates(List<org.jbpm.serverless.workflow.api.interfaces.State> states) {
        this.states = states;
        return this;
    }

    @Override
    public ForEachState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public ForEachState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public ForEachState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public ForEachState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public ForEachState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public ForEachState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public ForEachState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public ForEachState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public ForEachState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public ForEachState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public ForEachState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

}
