
package org.jbpm.serverless.workflow.api.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import org.jbpm.serverless.workflow.api.actions.Action;
import org.jbpm.serverless.workflow.api.end.End;
import org.jbpm.serverless.workflow.api.error.Error;
import org.jbpm.serverless.workflow.api.filters.StateDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.State;
import org.jbpm.serverless.workflow.api.retry.Retry;
import org.jbpm.serverless.workflow.api.start.Start;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * This state allows one or more functions to run in sequence or in parallel without waiting for any event.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "actionMode",
    "actions"
})
public class OperationState
    extends DefaultState
    implements Serializable, State
{

    /**
     * Specifies whether functions are executed in sequence or in parallel.
     * (Required)
     * 
     */
    @JsonProperty("actionMode")
    @JsonPropertyDescription("Specifies whether functions are executed in sequence or in parallel.")
    @NotNull
    private OperationState.ActionMode actionMode;
    /**
     * Actions Definitions
     * (Required)
     * 
     */
    @JsonProperty("actions")
    @JsonPropertyDescription("Actions Definitions")
    @Valid
    @NotNull
    private List<Action> actions = new ArrayList<Action>();
    private final static long serialVersionUID = -3530262158584553246L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public OperationState() {
    }

    /**
     * 
     * @param actionMode
     * @param name
     * @param type
     * @param actions
     */
    public OperationState(OperationState.ActionMode actionMode, List<Action> actions, java.lang.String name, DefaultState.Type type) {
        super(name, type);
        this.actionMode = actionMode;
        this.actions = actions;
    }

    /**
     * Specifies whether functions are executed in sequence or in parallel.
     * (Required)
     * 
     */
    @JsonProperty("actionMode")
    public OperationState.ActionMode getActionMode() {
        return actionMode;
    }

    /**
     * Specifies whether functions are executed in sequence or in parallel.
     * (Required)
     * 
     */
    @JsonProperty("actionMode")
    public void setActionMode(OperationState.ActionMode actionMode) {
        this.actionMode = actionMode;
    }

    public OperationState withActionMode(OperationState.ActionMode actionMode) {
        this.actionMode = actionMode;
        return this;
    }

    /**
     * Actions Definitions
     * (Required)
     * 
     */
    @JsonProperty("actions")
    public List<Action> getActions() {
        return actions;
    }

    /**
     * Actions Definitions
     * (Required)
     * 
     */
    @JsonProperty("actions")
    public void setActions(List<Action> actions) {
        this.actions = actions;
    }

    public OperationState withActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public OperationState withId(java.lang.String id) {
        super.withId(id);
        return this;
    }

    @Override
    public OperationState withName(java.lang.String name) {
        super.withName(name);
        return this;
    }

    @Override
    public OperationState withType(DefaultState.Type type) {
        super.withType(type);
        return this;
    }

    @Override
    public OperationState withStart(Start start) {
        super.withStart(start);
        return this;
    }

    @Override
    public OperationState withEnd(End end) {
        super.withEnd(end);
        return this;
    }

    @Override
    public OperationState withStateDataFilter(StateDataFilter stateDataFilter) {
        super.withStateDataFilter(stateDataFilter);
        return this;
    }

    @Override
    public OperationState withMetadata(Map<String, String> metadata) {
        super.withMetadata(metadata);
        return this;
    }

    @Override
    public OperationState withTransition(Transition transition) {
        super.withTransition(transition);
        return this;
    }

    @Override
    public OperationState withDataInputSchema(java.lang.String dataInputSchema) {
        super.withDataInputSchema(dataInputSchema);
        return this;
    }

    @Override
    public OperationState withDataOutputSchema(java.lang.String dataOutputSchema) {
        super.withDataOutputSchema(dataOutputSchema);
        return this;
    }

    @Override
    public OperationState withOnError(List<Error> onError) {
        super.withOnError(onError);
        return this;
    }

    @Override
    public OperationState withRetry(List<Retry> retry) {
        super.withRetry(retry);
        return this;
    }

    public enum ActionMode {

        SEQUENTIAL("sequential"),
        PARALLEL("parallel");
        private final java.lang.String value;
        private final static Map<java.lang.String, OperationState.ActionMode> CONSTANTS = new HashMap<java.lang.String, OperationState.ActionMode>();

        static {
            for (OperationState.ActionMode c: values()) {
                CONSTANTS.put(c.value, c);
            }
        }

        private ActionMode(java.lang.String value) {
            this.value = value;
        }

        @Override
        public java.lang.String toString() {
            return this.value;
        }

        @JsonValue
        public java.lang.String value() {
            return this.value;
        }

        @JsonCreator
        public static OperationState.ActionMode fromValue(java.lang.String value) {
            OperationState.ActionMode constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            } else {
                return constant;
            }
        }

    }

}
