
package org.jbpm.serverless.workflow.api.retry;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.expression.Expression;


/**
 * Retry Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "expression",
    "interval",
    "multiplier",
    "maxAttempts"
})
public class Retry implements Serializable
{

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    @Valid
    @NotNull
    private Expression expression;
    /**
     * Specifies the amount of time between retries (ISO 8601 format)
     * 
     */
    @JsonProperty("interval")
    @JsonPropertyDescription("Specifies the amount of time between retries (ISO 8601 format)")
    private String interval;
    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    @JsonPropertyDescription("Multiplier value by which interval increases during each attempt (ISO 8601 time format)")
    private String multiplier;
    /**
     * Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed
     * 
     */
    @JsonProperty("maxAttempts")
    @JsonPropertyDescription("Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed")
    @DecimalMin("0")
    private int maxAttempts = 0;
    private final static long serialVersionUID = -2255817227153669082L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Retry() {
    }

    /**
     * 
     * @param expression
     */
    public Retry(Expression expression) {
        super();
        this.expression = expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public Expression getExpression() {
        return expression;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("expression")
    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Retry withExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    /**
     * Specifies the amount of time between retries (ISO 8601 format)
     * 
     */
    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    /**
     * Specifies the amount of time between retries (ISO 8601 format)
     * 
     */
    @JsonProperty("interval")
    public void setInterval(String interval) {
        this.interval = interval;
    }

    public Retry withInterval(String interval) {
        this.interval = interval;
        return this;
    }

    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    public String getMultiplier() {
        return multiplier;
    }

    /**
     * Multiplier value by which interval increases during each attempt (ISO 8601 time format)
     * 
     */
    @JsonProperty("multiplier")
    public void setMultiplier(String multiplier) {
        this.multiplier = multiplier;
    }

    public Retry withMultiplier(String multiplier) {
        this.multiplier = multiplier;
        return this;
    }

    /**
     * Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed
     * 
     */
    @JsonProperty("maxAttempts")
    public int getMaxAttempts() {
        return maxAttempts;
    }

    /**
     * Maximum number of retry attempts (1 by default). Value of 0 means no retries are performed
     * 
     */
    @JsonProperty("maxAttempts")
    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Retry withMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

}
