/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.switchconditions.DataCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConditionOperatorDeserializer
extends StdDeserializer<DataCondition.Operator> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(DataConditionOperatorDeserializer.class);
    private WorkflowPropertySource context;

    public DataConditionOperatorDeserializer() {
        this(DataCondition.Operator.class);
    }

    public DataConditionOperatorDeserializer(WorkflowPropertySource context) {
        this(DataCondition.Operator.class);
        this.context = context;
    }

    public DataConditionOperatorDeserializer(Class<?> vc) {
        super(vc);
    }

    public DataCondition.Operator deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return DataCondition.Operator.fromValue(result);
                }
                return DataCondition.Operator.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return DataCondition.Operator.fromValue(jp.getText());
            }
        }
        return DataCondition.Operator.fromValue(jp.getText());
    }
}

