/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jbpm.serverless.workflow.api.WorkflowPropertySource;
import org.jbpm.serverless.workflow.api.states.DefaultState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStateTypeDeserializer
extends StdDeserializer<DefaultState.Type> {
    private static final long serialVersionUID = 510L;
    private static Logger logger = LoggerFactory.getLogger(DefaultStateTypeDeserializer.class);
    private WorkflowPropertySource context;

    public DefaultStateTypeDeserializer() {
        this(DefaultState.Type.class);
    }

    public DefaultStateTypeDeserializer(WorkflowPropertySource context) {
        this(DefaultState.Type.class);
        this.context = context;
    }

    public DefaultStateTypeDeserializer(Class<?> vc) {
        super(vc);
    }

    public DefaultState.Type deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String value = jp.getText();
        if (this.context != null) {
            try {
                String result = this.context.getPropertySource().getProperty(value);
                if (result != null) {
                    return DefaultState.Type.fromValue(result);
                }
                return DefaultState.Type.fromValue(jp.getText());
            }
            catch (Exception e) {
                logger.info("Exception trying to evaluate property: {}", (Object)e.getMessage());
                return DefaultState.Type.fromValue(jp.getText());
            }
        }
        return DefaultState.Type.fromValue(jp.getText());
    }
}

