/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.serverless.workflow.api.switchconditions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.jbpm.serverless.workflow.api.interfaces.SwitchCondition;
import org.jbpm.serverless.workflow.api.transitions.Transition;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"path", "value", "operator", "transition"})
public class DataCondition
implements Serializable,
SwitchCondition {
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="JSONPath expression that selects elements of state data")
    @NotNull
    private String path;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Matching value")
    @NotNull
    private String value;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Condition operator")
    @NotNull
    private Operator operator;
    @JsonProperty(value="transition")
    @Valid
    @NotNull
    private Transition transition;
    private static final long serialVersionUID = 878469266715403371L;

    public DataCondition() {
    }

    public DataCondition(String path, String value, Operator operator, Transition transition) {
        this.path = path;
        this.value = value;
        this.operator = operator;
        this.transition = transition;
    }

    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    public void setPath(String path) {
        this.path = path;
    }

    public DataCondition withPath(String path) {
        this.path = path;
        return this;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    public void setValue(String value) {
        this.value = value;
    }

    public DataCondition withValue(String value) {
        this.value = value;
        return this;
    }

    @JsonProperty(value="operator")
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public DataCondition withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty(value="transition")
    public Transition getTransition() {
        return this.transition;
    }

    @JsonProperty(value="transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public DataCondition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

    public static enum Operator {
        EXISTS("exists"),
        NOTEXISTS("notexists"),
        NULL("null"),
        NOTNULL("notnull"),
        EQUALS("equals"),
        NOTEQUALS("notequals"),
        LESSTHAN("lessthan"),
        LESSTHANOREQUALS("lessthanorequals"),
        GREATERTHAN("greaterthan"),
        GREATERTHANOREQUALS("greaterthanorequals"),
        MATCHES("matches"),
        NOTMATCHES("notmatches"),
        CUSTOM("custom");

        private final String value;
        private static final Map<String, Operator> CONSTANTS;

        private Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Operator fromValue(String value) {
            Operator constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Operator>();
            for (Operator c : Operator.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

