
package org.jbpm.serverless.workflow.api.switchconditions;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.filters.EventDataFilter;
import org.jbpm.serverless.workflow.api.interfaces.SwitchCondition;
import org.jbpm.serverless.workflow.api.transitions.Transition;


/**
 * Switch state data event condition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "eventRef",
    "eventDataFilter",
    "transition"
})
public class EventCondition implements Serializable, SwitchCondition
{

    /**
     * References an unique event name in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    @JsonPropertyDescription("References an unique event name in the defined workflow events")
    @NotNull
    private String eventRef;
    @JsonProperty("eventDataFilter")
    @Valid
    private EventDataFilter eventDataFilter;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    @Valid
    @NotNull
    private Transition transition;
    private final static long serialVersionUID = 3773689413236511562L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public EventCondition() {
    }

    /**
     * 
     * @param eventRef
     * @param transition
     */
    public EventCondition(String eventRef, Transition transition) {
        super();
        this.eventRef = eventRef;
        this.transition = transition;
    }

    /**
     * References an unique event name in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    public String getEventRef() {
        return eventRef;
    }

    /**
     * References an unique event name in the defined workflow events
     * (Required)
     * 
     */
    @JsonProperty("eventRef")
    public void setEventRef(String eventRef) {
        this.eventRef = eventRef;
    }

    public EventCondition withEventRef(String eventRef) {
        this.eventRef = eventRef;
        return this;
    }

    @JsonProperty("eventDataFilter")
    public EventDataFilter getEventDataFilter() {
        return eventDataFilter;
    }

    @JsonProperty("eventDataFilter")
    public void setEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
    }

    public EventCondition withEventDataFilter(EventDataFilter eventDataFilter) {
        this.eventDataFilter = eventDataFilter;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public Transition getTransition() {
        return transition;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("transition")
    public void setTransition(Transition transition) {
        this.transition = transition;
    }

    public EventCondition withTransition(Transition transition) {
        this.transition = transition;
        return this;
    }

}
