/*
 *
 *   Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */

package org.jbpm.serverless.workflow.api;

import org.jbpm.serverless.workflow.api.interfaces.Extension;

public interface WorkflowManager {

    void setWorkflow(Workflow workflow);

    Workflow getWorkflow();

    WorkflowManager setMarkup(String markup);

    void setExpressionEvaluator(ExpressionEvaluator expressionEvaluator);

    void setDefaultExpressionEvaluator(String evaluatorName);

    ExpressionEvaluator getExpressionEvaluator();

    ExpressionEvaluator getExpressionEvaluator(String evaluatorName);

    void resetExpressionValidator();

    WorkflowValidator getWorkflowValidator();

    String toJson();

    String toYaml();

    Workflow toWorkflow(String json);

    void registerExtension(String extensionId, Class<? extends Extension> extensionHandlerClass);
}