
package org.jbpm.serverless.workflow.api.actions;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import org.jbpm.serverless.workflow.api.filters.ActionDataFilter;
import org.jbpm.serverless.workflow.api.functions.FunctionRef;


/**
 * Action Definition
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "name",
    "functionRef",
    "actionDataFilter"
})
public class Action implements Serializable
{

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    @JsonPropertyDescription("Unique action definition name")
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("functionRef")
    @Valid
    @NotNull
    private FunctionRef functionRef;
    @JsonProperty("actionDataFilter")
    @Valid
    private ActionDataFilter actionDataFilter;
    private final static long serialVersionUID = -311605053512018231L;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Action() {
    }

    /**
     * 
     * @param functionRef
     */
    public Action(FunctionRef functionRef) {
        super();
        this.functionRef = functionRef;
    }

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * Unique action definition name
     * 
     */
    @JsonProperty("name")
    public void setName(String name) {
        this.name = name;
    }

    public Action withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("functionRef")
    public FunctionRef getFunctionRef() {
        return functionRef;
    }

    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("functionRef")
    public void setFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
    }

    public Action withFunctionRef(FunctionRef functionRef) {
        this.functionRef = functionRef;
        return this;
    }

    @JsonProperty("actionDataFilter")
    public ActionDataFilter getActionDataFilter() {
        return actionDataFilter;
    }

    @JsonProperty("actionDataFilter")
    public void setActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
    }

    public Action withActionDataFilter(ActionDataFilter actionDataFilter) {
        this.actionDataFilter = actionDataFilter;
        return this;
    }

}
